/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api;

import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.PrimitiveInstanceDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class ServiceProperty {
    private String m_name;
    private String m_field;
    private String m_type;
    private String m_value;
    private boolean m_mandatory;
    private boolean m_immutable;

    public ServiceProperty setName(String name) {
        this.m_name = name;
        return this;
    }

    public ServiceProperty setField(String name) {
        this.m_field = name;
        return this;
    }

    public ServiceProperty setType(String name) {
        this.m_type = name;
        return this;
    }

    public ServiceProperty setValue(String name) {
        this.m_value = name;
        return this;
    }

    public ServiceProperty setImmutable(boolean immutable) {
        this.m_immutable = immutable;
        return this;
    }

    public ServiceProperty setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        return this;
    }

    public Element getElement() {
        this.ensureValidity();
        Element element = new Element("property", "");
        if (this.m_name != null) {
            element.addAttribute(new Attribute("name", this.m_name));
        }
        if (this.m_type != null) {
            element.addAttribute(new Attribute("type", this.m_type));
        }
        if (this.m_value != null) {
            element.addAttribute(new Attribute("value", this.m_value));
        }
        if (this.m_field != null) {
            element.addAttribute(new Attribute("field", this.m_field));
        }
        if (this.m_mandatory) {
            element.addAttribute(new Attribute("mandatory", new Boolean(this.m_mandatory).toString()));
        }
        if (this.m_immutable) {
            element.addAttribute(new Attribute("immutable", new Boolean(this.m_immutable).toString()));
        }
        return element;
    }

    private void ensureValidity() {
        if (this.m_field == null && this.m_type == null) {
            throw new IllegalStateException("A service property must have either a field or a type");
        }
        if (this.m_immutable && this.m_value == null) {
            throw new IllegalStateException("A immutable service property must have a value");
        }
    }

    public Object getPropertyValue(ComponentInstance instance) {
        PrimitiveInstanceDescription desc = (PrimitiveInstanceDescription)instance.getInstanceDescription();
        ProvidedServiceDescription[] pss = desc.getProvidedServices();
        for (int i = 0; i < pss.length; ++i) {
            if (this.m_name != null && pss[i].getProperties().containsKey(this.m_name)) {
                return pss[i].getProperties().get(this.m_name);
            }
            if (this.m_field == null || !pss[i].getProperties().containsKey(this.m_field)) continue;
            return pss[i].getProperties().get(this.m_field);
        }
        return null;
    }
}

