/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.reporter;

import java.io.PrintStream;
import org.apache.felix.ipojo.manipulator.reporter.EmptyReporter;

public class SystemReporter
extends EmptyReporter {
    private boolean enableTrace = false;

    public void setEnableTrace(boolean enableTrace) {
        this.enableTrace = enableTrace;
    }

    private void log(PrintStream stream, Level level, String formatted, Throwable throwable) {
        stream.println(level.append(formatted));
        if (throwable != null) {
            throwable.printStackTrace(stream);
        }
    }

    @Override
    public void trace(String message, Object ... args) {
        if (this.enableTrace) {
            String formatted = String.format(message, this.getMessageArguments(args));
            this.log(System.out, Level.TRACE, formatted, this.getThrowable(new Object[0]));
        }
    }

    @Override
    public void info(String message, Object ... args) {
        String formatted = String.format(message, this.getMessageArguments(args));
        this.log(System.out, Level.INFO, formatted, this.getThrowable(new Object[0]));
    }

    @Override
    public void warn(String message, Object ... args) {
        String formatted = String.format(message, this.getMessageArguments(args));
        Throwable throwable = this.getThrowable(new Object[0]);
        this.log(System.out, Level.WARN, formatted, throwable);
        if (throwable != null) {
            formatted = formatted + " ";
            formatted = formatted + throwable.getMessage();
        }
        this.getWarnings().add(formatted);
    }

    @Override
    public void error(String message, Object ... args) {
        String formatted = String.format(message, this.getMessageArguments(args));
        Throwable throwable = this.getThrowable(new Object[0]);
        this.log(System.out, Level.ERROR, formatted, throwable);
        if (throwable != null) {
            formatted = formatted + " ";
            formatted = formatted + throwable.getMessage();
        }
        this.getErrors().add(formatted);
    }

    private static enum Level {
        TRACE("#"),
        INFO("I"),
        WARN("W"),
        ERROR("E");

        private String value;

        private Level(String value) {
            this.value = value;
        }

        public String append(String message) {
            return this.value + " " + message;
        }
    }
}

