/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.InstanceStateListener;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.composite.CompositeFactory;
import org.apache.felix.ipojo.composite.CompositeHandler;
import org.apache.felix.ipojo.composite.CompositeInstanceDescription;
import org.apache.felix.ipojo.composite.CompositeServiceContext;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Logger;
import org.osgi.framework.BundleContext;

public class CompositeManager
implements ComponentInstance,
InstanceStateListener {
    private final BundleContext m_context;
    private final CompositeFactory m_factory;
    private HandlerManager[] m_handlers;
    private List m_listeners = new ArrayList();
    private CompositeServiceContext m_internalContext;
    private final CompositeInstanceDescription m_description;
    private String m_name;
    private int m_state = 0;
    private Logger m_logger;

    public CompositeManager(CompositeFactory factory, BundleContext context, HandlerManager[] handlers) {
        this.m_factory = factory;
        this.m_context = context;
        this.m_internalContext = new CompositeServiceContext(this.m_context, this);
        this.m_handlers = handlers;
        this.m_description = new CompositeInstanceDescription(this.m_factory.getComponentDescription(), this);
        this.m_logger = new Logger(this.m_context, (ComponentInstance)this);
    }

    public synchronized void addCompositeHandler(HandlerManager handler) {
        if (this.m_handlers.length > 0) {
            HandlerManager[] newInstances = new HandlerManager[this.m_handlers.length + 1];
            System.arraycopy(this.m_handlers, 0, newInstances, 0, this.m_handlers.length);
            newInstances[this.m_handlers.length] = handler;
            this.m_handlers = newInstances;
        } else {
            this.m_handlers = new HandlerManager[]{handler};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceStateListener(InstanceStateListener listener) {
        List list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(listener);
        }
    }

    public void configure(Element metadata, Dictionary configuration) throws ConfigurationException {
        this.m_name = (String)configuration.get("instance.name");
        for (int i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].init((ComponentInstance)this, metadata, configuration);
        }
    }

    public void dispose() {
        int i;
        if (this.m_state > 0) {
            this.stop();
        }
        for (i = 0; i < this.m_listeners.size(); ++i) {
            ((InstanceStateListener)this.m_listeners.get(i)).stateChanged((ComponentInstance)this, -1);
        }
        this.m_factory.disposed(this);
        this.m_state = -1;
        for (i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].dispose();
        }
        this.m_handlers = new HandlerManager[0];
        this.m_listeners.clear();
    }

    public CompositeHandler getCompositeHandler(String name) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            HandlerFactory fact = (HandlerFactory)this.m_handlers[i].getFactory();
            if (!fact.getHandlerName().equals(name) && !name.equals(fact.getComponentDescription().getClassName())) continue;
            return (CompositeHandler)this.m_handlers[i].getHandler();
        }
        return null;
    }

    public BundleContext getContext() {
        return this.m_context;
    }

    public ComponentFactory getFactory() {
        return this.m_factory;
    }

    public BundleContext getGlobalContext() {
        IPojoContext context = (IPojoContext)this.m_context;
        return context.getGlobalContext();
    }

    public InstanceDescription getInstanceDescription() {
        return this.m_description;
    }

    public String getInstanceName() {
        return this.m_name;
    }

    public ServiceContext getParentServiceContext() {
        IPojoContext context = (IPojoContext)this.m_context;
        return context.getServiceContext();
    }

    public CompositeHandler[] getRegistredCompositeHandlers() {
        CompositeHandler[] handler = new CompositeHandler[this.m_handlers.length];
        for (int i = 0; i < this.m_handlers.length; ++i) {
            handler[i] = (CompositeHandler)this.m_handlers[i].getHandler();
        }
        return handler;
    }

    public ServiceContext getServiceContext() {
        return this.m_internalContext;
    }

    public int getState() {
        return this.m_state;
    }

    public boolean isStarted() {
        return this.m_state > 0;
    }

    public void reconfigure(Dictionary configuration) {
        this.m_logger.log(3, "Reconfiguring composite with " + configuration);
        for (int i = 0; i < this.m_handlers.length; ++i) {
            this.m_logger.log(3, "Delegating reconfiguration to " + this.m_handlers[i].getClassName());
            this.m_handlers[i].getHandler().reconfigure(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceStateListener(InstanceStateListener listener) {
        List list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.remove(listener);
        }
    }

    public void setState(int state) {
        block5: {
            int i;
            if (this.m_state == state) break block5;
            if (state > this.m_state) {
                this.m_state = state;
                for (i = 0; i < this.m_handlers.length; ++i) {
                    this.m_handlers[i].getHandler().stateChanged(state);
                }
            } else {
                this.m_state = state;
                for (i = this.m_handlers.length - 1; i > -1; --i) {
                    this.m_handlers[i].getHandler().stateChanged(state);
                }
            }
            for (i = 0; i < this.m_listeners.size(); ++i) {
                ((InstanceStateListener)this.m_listeners.get(i)).stateChanged((ComponentInstance)this, state);
            }
        }
    }

    public synchronized void start() {
        int i;
        if (this.m_state > 0) {
            return;
        }
        this.m_state = 1;
        this.m_internalContext.start();
        CompositeHandler[] handlers = this.getRegistredCompositeHandlers();
        for (i = 0; i < handlers.length; ++i) {
            this.m_description.addHandler(handlers[i].getDescription());
        }
        for (i = 0; i < this.m_handlers.length; ++i) {
            this.m_handlers[i].start();
            this.m_handlers[i].addInstanceStateListener((InstanceStateListener)this);
        }
        for (i = 0; i < this.m_handlers.length; ++i) {
            if (this.m_handlers[i].getState() == 2) continue;
            this.setState(1);
            return;
        }
        this.setState(2);
    }

    public synchronized void stateChanged(ComponentInstance instance, int newState) {
        if (this.m_state <= 0) {
            return;
        }
        if (newState == 1 && this.m_state == 2) {
            this.setState(1);
            return;
        }
        if (newState == 2 && this.m_state == 1) {
            boolean isValid = true;
            for (int i = 0; i < this.m_handlers.length; ++i) {
                isValid = isValid && this.m_handlers[i].getState() == 2;
            }
            if (isValid) {
                this.setState(2);
            }
        }
        if (newState == -1) {
            this.kill();
        }
    }

    public synchronized void stop() {
        int i;
        if (this.m_state <= 0) {
            return;
        }
        this.setState(1);
        for (i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].removeInstanceStateListener((InstanceStateListener)this);
            this.m_handlers[i].stop();
        }
        this.m_internalContext.stop();
        this.m_state = 0;
        for (i = 0; i < this.m_listeners.size(); ++i) {
            ((InstanceStateListener)this.m_listeners.get(i)).stateChanged((ComponentInstance)this, 0);
        }
    }

    protected synchronized void kill() {
        int i;
        if (this.m_state > 0) {
            this.stop();
        }
        for (i = 0; i < this.m_listeners.size(); ++i) {
            ((InstanceStateListener)this.m_listeners.get(i)).stateChanged((ComponentInstance)this, -1);
        }
        this.m_state = -1;
        for (i = this.m_handlers.length - 1; i > -1; --i) {
            this.m_handlers[i].dispose();
        }
        this.m_handlers = new HandlerManager[0];
        this.m_listeners.clear();
    }
}

