/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.jmx;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.ipojo.handlers.jmx.MethodField;
import org.apache.felix.ipojo.handlers.jmx.NotificationField;
import org.apache.felix.ipojo.handlers.jmx.PropertyField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxConfigFieldMap {
    private Map<String, PropertyField> m_properties = new HashMap<String, PropertyField>();
    private Map<String, MethodField[]> m_methods = new HashMap<String, MethodField[]>();
    private Map<String, NotificationField> m_notifications = new HashMap<String, NotificationField>();
    private String m_description;

    public String getDecription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void addPropertyFromName(String name, PropertyField propertyField) {
        this.m_properties.put(name, propertyField);
    }

    public Collection<PropertyField> getProperties() {
        if (this.m_properties != null) {
            return this.m_properties.values();
        }
        return null;
    }

    public PropertyField getPropertyFromName(String name) {
        PropertyField prop = this.m_properties.get(name);
        return prop;
    }

    public PropertyField getPropertyFromField(String field) {
        PropertyField property = null;
        for (PropertyField p : this.m_properties.values()) {
            if (p.getField().compareTo(field) != 0) continue;
            if (property != null) {
                System.err.println("a field already exists");
                continue;
            }
            property = p;
        }
        return property;
    }

    public void addMethodFromName(String name, MethodField methodField) {
        MethodField[] mf;
        if (!this.m_methods.containsKey(name)) {
            mf = new MethodField[]{methodField};
        } else {
            MethodField[] temp = this.m_methods.get(name);
            mf = new MethodField[temp.length + 1];
            for (int i = 0; i < temp.length; ++i) {
                mf[i] = temp[i];
            }
            mf[temp.length] = methodField;
        }
        this.m_methods.put(name, mf);
    }

    public void addMethodFromName(String name, MethodField[] methodsField) {
        MethodField[] mf;
        if (!this.m_methods.containsKey(name)) {
            mf = methodsField;
        } else {
            int i;
            MethodField[] temp = this.m_methods.get(name);
            mf = new MethodField[temp.length + methodsField.length];
            for (i = 0; i < temp.length; ++i) {
                mf[i] = temp[i];
            }
            for (i = 0; i < methodsField.length; ++i) {
                mf[i + temp.length] = methodsField[i];
            }
        }
        this.m_methods.put(name, mf);
    }

    public void overrideMethodFromName(String name, MethodField methodField) {
        MethodField[] mf = new MethodField[]{methodField};
        this.m_methods.put(name, mf);
    }

    public void overrideMethodFromName(String name, MethodField[] methodsField) {
        this.m_methods.put(name, methodsField);
    }

    public MethodField[] getMethodFromName(String name) {
        MethodField[] prop = this.m_methods.get(name);
        return prop;
    }

    public MethodField getMethodFromName(String operationName, String[] signature) {
        MethodField[] methods = this.m_methods.get(operationName);
        for (int i = 0; i < methods.length; ++i) {
            if (!this.isSameSignature(signature, methods[i].getSignature())) continue;
            return methods[i];
        }
        return null;
    }

    private boolean isSameSignature(String[] sig1, String[] sig2) {
        if (sig1.length != sig2.length) {
            return false;
        }
        for (int i = 0; i < sig1.length; ++i) {
            if (sig1[i].equals(sig2[i])) continue;
            return false;
        }
        return true;
    }

    public Collection<MethodField[]> getMethods() {
        if (this.m_methods != null) {
            return this.m_methods.values();
        }
        return null;
    }

    public void addNotificationFromName(String name, NotificationField notificationField) {
        this.m_notifications.put(name, notificationField);
    }

    public NotificationField getNotificationFromName(String name) {
        NotificationField prop = this.m_notifications.get(name);
        return prop;
    }

    public Collection<NotificationField> getNotifications() {
        if (this.m_notifications != null) {
            return this.m_notifications.values();
        }
        return null;
    }
}

