/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handler.temporal;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.FieldInterceptor;
import org.apache.felix.ipojo.MethodInterceptor;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.handler.temporal.ProxyGenerator;
import org.apache.felix.ipojo.handler.temporal.ServiceCollection;
import org.apache.felix.ipojo.handler.temporal.ServiceUsage;
import org.apache.felix.ipojo.handler.temporal.TemporalHandler;
import org.apache.felix.ipojo.handlers.dependency.NullableObject;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;

public class TemporalDependency
extends DependencyModel
implements FieldInterceptor,
MethodInterceptor {
    private long m_timeout;
    private String m_di;
    private Object m_nullableObject;
    private PrimitiveHandler m_handler;
    private int m_policy;
    private boolean m_collection;
    private boolean m_proxy;
    private ServiceUsage m_usage;
    private Object m_proxyObject;
    static /* synthetic */ Class class$org$apache$felix$ipojo$Nullable;

    public TemporalDependency(Class spec, boolean agg, boolean collection, boolean proxy, Filter filter, BundleContext context, long timeout, int policy, String defaultImpl, TemporalHandler handler) {
        super(spec, agg, true, filter, null, 0, context, (DependencyStateListener)handler, (ComponentInstance)handler.getInstanceManager());
        this.m_di = defaultImpl;
        this.m_policy = policy;
        this.m_timeout = timeout;
        this.m_handler = handler;
        this.m_collection = collection;
        this.m_proxy = proxy;
        if (!proxy) {
            this.m_usage = new ServiceUsage();
        } else if (proxy && !agg) {
            ProxyFactory proxyFactory = new ProxyFactory(((Object)((Object)this)).getClass().getClassLoader());
            this.m_proxyObject = proxyFactory.getProxy(this.getSpecification(), this);
        }
    }

    public void onDependencyReconfiguration(ServiceReference[] arg0, ServiceReference[] arg1) {
        throw new UnsupportedOperationException("Reconfiguration not yet supported");
    }

    public synchronized void onServiceArrival(ServiceReference ref) {
        ((Object)((Object)this)).notifyAll();
    }

    public void onServiceDeparture(ServiceReference arg0) {
    }

    public void onServiceModification(ServiceReference arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Object onGet(Object arg0, String arg1, Object arg2) {
        ServiceReference[] refs;
        if (!this.m_proxy) {
            ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
            if (usage.m_stack > 0) {
                return usage.m_object;
            }
        }
        if ((refs = this.getServiceReferences()) != null) {
            return this.getServiceObjects(refs);
        }
        long enter = System.currentTimeMillis();
        boolean exhausted = false;
        TemporalDependency temporalDependency = this;
        synchronized (temporalDependency) {
            while (this.getServiceReference() == null && !exhausted) {
                long end;
                try {
                    ((Object)((Object)this)).wait(1L);
                }
                catch (InterruptedException e) {
                    end = System.currentTimeMillis();
                    exhausted = end - enter > this.m_timeout;
                    continue;
                    catch (Throwable throwable) {
                        long end2 = System.currentTimeMillis();
                        exhausted = end2 - enter > this.m_timeout;
                        throw throwable;
                    }
                }
                end = System.currentTimeMillis();
                exhausted = end - enter > this.m_timeout;
            }
        }
        if (exhausted) {
            return this.onTimeout();
        }
        refs = this.getServiceReferences();
        return this.getServiceObjects(refs);
    }

    public void onEntry(Object pojo, Method method, Object[] args) {
        if (this.m_usage != null) {
            ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
            if (usage.m_stack > 0) {
                usage.inc();
                this.m_usage.set(usage);
            }
        }
    }

    public void onError(Object pojo, Method method, Throwable throwable) {
    }

    public void onExit(Object pojo, Method method, Object returnedObj) {
    }

    public void onFinally(Object pojo, Method method) {
        if (this.m_usage != null) {
            ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
            if (usage.m_stack > 0 && usage.dec()) {
                usage.clear();
                this.m_usage.set(usage);
            }
        }
    }

    private Object getServiceObjects(ServiceReference[] refs) {
        if (this.m_proxy) {
            if (this.m_proxyObject == null) {
                return new ServiceCollection(this);
            }
            return this.m_proxyObject;
        }
        ServiceUsage.Usage usage = (ServiceUsage.Usage)this.m_usage.get();
        if (usage.m_stack == 0) {
            if (this.isAggregate()) {
                if (this.m_collection) {
                    ArrayList<Object> svc = new ArrayList<Object>(refs.length);
                    for (int i = 0; i < refs.length; ++i) {
                        svc.add(this.getService(refs[i]));
                    }
                    usage.m_object = svc;
                } else {
                    Object[] svc = (Object[])Array.newInstance(this.getSpecification(), refs.length);
                    for (int i = 0; i < svc.length; ++i) {
                        svc[i] = this.getService(refs[i]);
                    }
                    usage.m_object = svc;
                }
            } else {
                usage.m_object = this.getService(refs[0]);
            }
            usage.inc();
            this.m_usage.set(usage);
        }
        return usage.m_object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object getService() {
        ServiceReference ref = this.getServiceReference();
        if (ref != null) {
            return this.getService(ref);
        }
        long enter = System.currentTimeMillis();
        boolean exhausted = false;
        TemporalDependency temporalDependency = this;
        synchronized (temporalDependency) {
            while (ref == null && !exhausted) {
                long end;
                try {
                    ((Object)((Object)this)).wait(1L);
                }
                catch (InterruptedException e) {
                    end = System.currentTimeMillis();
                    exhausted = end - enter > this.m_timeout;
                    ref = this.getServiceReference();
                    continue;
                    catch (Throwable throwable) {
                        long end2 = System.currentTimeMillis();
                        exhausted = end2 - enter > this.m_timeout;
                        ref = this.getServiceReference();
                        throw throwable;
                    }
                }
                end = System.currentTimeMillis();
                exhausted = end - enter > this.m_timeout;
                ref = this.getServiceReference();
            }
        }
        if (exhausted) {
            Object obj = this.onTimeout();
            if (obj == null) {
                throw new NullPointerException("No service available");
            }
            return obj;
        }
        return this.getService(ref);
    }

    public void start() {
        super.start();
        switch (this.m_policy) {
            case 4: {
                this.m_nullableObject = null;
                break;
            }
            case 1: {
                try {
                    this.m_nullableObject = Proxy.newProxyInstance(this.m_handler.getInstanceManager().getClazz().getClassLoader(), new Class[]{this.getSpecification(), class$org$apache$felix$ipojo$Nullable == null ? (class$org$apache$felix$ipojo$Nullable = TemporalDependency.class$("org.apache.felix.ipojo.Nullable")) : class$org$apache$felix$ipojo$Nullable}, (InvocationHandler)new NullableObject());
                    if (!this.isAggregate()) break;
                    if (this.m_collection) {
                        ArrayList<Object> list = new ArrayList<Object>(1);
                        list.add(this.m_nullableObject);
                        this.m_nullableObject = list;
                        break;
                    }
                    Object[] array = (Object[])Array.newInstance(this.getSpecification(), 1);
                    array[0] = this.m_nullableObject;
                    this.m_nullableObject = array;
                    break;
                }
                catch (NoClassDefFoundError e) {
                    throw new IllegalStateException("Cannot create the Nullable object, a referenced class cannot be loaded: " + e.getMessage());
                }
            }
            case 2: {
                try {
                    Class clazz = this.m_handler.getInstanceManager().getContext().getBundle().loadClass(this.m_di);
                    this.m_nullableObject = clazz.newInstance();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Cannot load the default-implementation " + this.m_di + " : " + e.getMessage());
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Cannot load the default-implementation " + this.m_di + " : " + e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot load the default-implementation " + this.m_di + " : " + e.getMessage());
                }
                if (!this.isAggregate()) break;
                if (this.m_collection) {
                    ArrayList<Object> list = new ArrayList<Object>(1);
                    list.add(this.m_nullableObject);
                    this.m_nullableObject = list;
                    break;
                }
                Object[] array = (Object[])Array.newInstance(this.getSpecification(), 1);
                array[0] = this.m_nullableObject;
                this.m_nullableObject = array;
                break;
            }
            case 3: {
                if (!this.m_collection) {
                    this.m_nullableObject = Array.newInstance(this.getSpecification(), 0);
                    break;
                }
                this.m_nullableObject = new ArrayList(0);
                break;
            }
        }
    }

    public void stop() {
        super.stop();
        this.m_nullableObject = null;
        this.m_proxyObject = null;
    }

    public void onSet(Object arg0, String arg1, Object arg2) {
    }

    Object onTimeout() {
        switch (this.m_policy) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.m_nullableObject;
            }
        }
        throw new RuntimeException("Service " + this.getSpecification().getName() + " unavailable : timeout");
    }

    long getTimeout() {
        return this.m_timeout;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProxyFactory
    extends ClassLoader {
        private ClassLoader m_handlerCL;

        public ProxyFactory(ClassLoader parent) {
            this.m_handlerCL = parent;
        }

        protected Class getProxyClass(Class clazz) {
            byte[] clz = ProxyGenerator.dumpProxy(clazz);
            return this.defineClass(clazz.getName() + "$$Proxy", clz, 0, clz.length);
        }

        public Object getProxy(Class spec, TemporalDependency dep) {
            try {
                Class clazz = this.getProxyClass(TemporalDependency.this.getSpecification());
                Constructor constructor = clazz.getConstructor(((Object)((Object)dep)).getClass());
                return constructor.newInstance(new Object[]{dep});
            }
            catch (Throwable e) {
                TemporalDependency.this.m_handler.error("Cannot create the proxy object", e);
                TemporalDependency.this.m_handler.getInstanceManager().stop();
                return null;
            }
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            try {
                return TemporalDependency.this.m_handler.getInstanceManager().getContext().getBundle().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.m_handlerCL.loadClass(name);
            }
        }
    }
}

