/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.online.manipulator;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.felix.ipojo.manipulator.render.MetadataRenderer;
import org.apache.felix.ipojo.manipulator.store.JarFileResourceStore;
import org.apache.felix.ipojo.manipulator.store.builder.DefaultManifestBuilder;
import org.apache.felix.ipojo.manipulator.util.Streams;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;

public class BundleAwareJarFileResourceStore
extends JarFileResourceStore {
    private final BundleContext bundleContext;

    public BundleAwareJarFileResourceStore(JarFile source, File target, BundleContext bundleContext) throws IOException {
        super(source, target);
        this.bundleContext = bundleContext;
        DefaultManifestBuilder manifestBuilder = new DefaultManifestBuilder();
        manifestBuilder.setMetadataRenderer(new MetadataRenderer());
        this.setManifestBuilder(manifestBuilder);
    }

    @Override
    public byte[] read(String path) throws IOException {
        try {
            return super.read(path);
        }
        catch (IOException iOException) {
            String directory = path.substring(0, path.lastIndexOf(47));
            String filename = path.substring(path.lastIndexOf(47) + 1);
            for (Bundle bundle : this.bundleContext.getBundles()) {
                BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                List entries = wiring.findEntries(directory, filename, 0);
                for (URL url : entries) {
                    try {
                        return Streams.readBytes(url.openStream());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            throw new IOException(String.format("Could not find %s in currently available bundles", path));
        }
    }
}

