/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.felix.upnp.basedriver.controller.impl.DriverControllerImpl;
import org.apache.felix.upnp.basedriver.export.RootDeviceExportingQueue;
import org.apache.felix.upnp.basedriver.export.RootDeviceListener;
import org.apache.felix.upnp.basedriver.export.ThreadExporter;
import org.apache.felix.upnp.basedriver.importer.core.MyCtrlPoint;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.Monitor;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.NotifierQueue;
import org.apache.felix.upnp.basedriver.importer.core.event.structs.SubscriptionQueue;
import org.apache.felix.upnp.basedriver.importer.core.event.thread.Notifier;
import org.apache.felix.upnp.basedriver.importer.core.event.thread.SubScriber;
import org.apache.felix.upnp.basedriver.tool.Logger;
import org.cybergarage.upnp.UPnP;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    public static BundleContext bc;
    public static Logger logger;
    private RootDeviceExportingQueue queue;
    private RootDeviceListener producerDeviceToExport;
    private ThreadExporter consumerDeviceToExport;
    private MyCtrlPoint ctrl;
    private SubScriber subScriber;
    private Notifier notifier;
    private NotifierQueue notifierQueue;
    private SubscriptionQueue subQueue;
    private Monitor monitor;
    private DriverControllerImpl drvController;
    private ServiceRegistration drvControllerRegistrar;
    private Properties configuration;
    static /* synthetic */ Class class$org$apache$felix$upnp$basedriver$Activator;
    static /* synthetic */ Class class$org$apache$felix$upnp$basedriver$controller$DriverController;
    static /* synthetic */ Class class$org$apache$felix$upnp$basedriver$controller$DevicesInfo;

    public void start(BundleContext context) throws Exception {
        bc = context;
        this.doInitProperties();
        this.doInitLogger();
        this.doInitUPnPStack();
        this.doInitExporter();
        this.doInitImporter();
        this.doControllerRegistration();
        logger.DEBUG("org.apache.felix.upnp.basedriver Configuration:\n" + this.configuration.toString());
    }

    private void doInitProperties() {
        this.configuration = new Properties();
        try {
            this.configuration.load((class$org$apache$felix$upnp$basedriver$Activator == null ? (class$org$apache$felix$upnp$basedriver$Activator = Activator.class$("org.apache.felix.upnp.basedriver.Activator")) : class$org$apache$felix$upnp$basedriver$Activator).getResourceAsStream("resources/upnp.properties"));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        Enumeration<?> e = this.configuration.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String systemValue = bc.getProperty(name);
            if (systemValue == null) continue;
            this.configuration.setProperty(name, systemValue);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.drvControllerRegistrar.unregister();
        if (this.consumerDeviceToExport != null) {
            this.consumerDeviceToExport.end();
            this.consumerDeviceToExport.cleanUp();
            this.producerDeviceToExport.deactive();
        }
        if (this.ctrl != null) {
            this.ctrl.stop();
            this.subScriber.close();
            this.notifier.close();
        }
        logger.close();
        logger = null;
        bc = null;
    }

    private void doInitLogger() {
        String levelStr = this.configuration.getProperty("felix.upnpbase.log", "2");
        logger = new Logger(levelStr);
        String cyberLog = this.configuration.getProperty("felix.upnpbase.cyberdomo.log", "false");
        logger.setCyberDebug(cyberLog);
    }

    private void doInitUPnPStack() {
        boolean useLoopback;
        boolean useOnlyIPV4 = Boolean.valueOf(this.configuration.getProperty("felix.upnpbase.cyberdomo.net.onlyIPV4", "true"));
        if (useOnlyIPV4) {
            UPnP.setEnable(9);
        } else {
            UPnP.setDisable(9);
        }
        String javaVersion = bc.getProperty("java.version");
        if (!(javaVersion == null || javaVersion.startsWith("1.0") || javaVersion.startsWith("1.1") || javaVersion.startsWith("1.2") || javaVersion.startsWith("1.3"))) {
            boolean useOnlyIPV6 = Boolean.valueOf(this.configuration.getProperty("felix.upnpbase.cyberdomo.net.onlyIPV6", "false"));
            boolean ALIAS_USE_ONLY_IPV6_ADDR = true;
            if (useOnlyIPV6) {
                UPnP.setEnable(1);
            } else {
                UPnP.setDisable(1);
            }
        }
        if (useLoopback = Boolean.valueOf(this.configuration.getProperty("felix.upnpbase.cyberdomo.net.loopback", "false")).booleanValue()) {
            UPnP.setEnable(2);
        } else {
            UPnP.setDisable(2);
        }
    }

    private void doInitExporter() throws InvalidSyntaxException {
        boolean useExporter = Boolean.valueOf(this.configuration.getProperty("felix.upnpbase.exporter.enabled", "true"));
        if (!useExporter) {
            return;
        }
        this.queue = new RootDeviceExportingQueue();
        this.producerDeviceToExport = new RootDeviceListener(this.queue);
        this.producerDeviceToExport.activate();
        this.consumerDeviceToExport = new ThreadExporter(this.queue);
        new Thread((Runnable)this.consumerDeviceToExport, "upnp.basedriver.Exporter").start();
    }

    private void doInitImporter() {
        boolean useImporter = Boolean.valueOf(this.configuration.getProperty("felix.upnpbase.importer.enabled", "true"));
        if (!useImporter) {
            return;
        }
        this.notifierQueue = new NotifierQueue();
        this.subQueue = new SubscriptionQueue();
        this.ctrl = new MyCtrlPoint(bc, this.subQueue, this.notifierQueue);
        this.ctrl.setNMPRMode(true);
        this.monitor = new Monitor();
        this.notifier = new Notifier(this.notifierQueue, this.monitor);
        this.subScriber = new SubScriber(this.ctrl, this.subQueue, this.monitor);
        this.ctrl.start();
        this.subScriber.start();
        this.notifier.start();
    }

    private void doControllerRegistration() {
        this.drvController = new DriverControllerImpl(this.ctrl);
        this.drvControllerRegistrar = bc.registerService(new String[]{(class$org$apache$felix$upnp$basedriver$controller$DriverController == null ? (class$org$apache$felix$upnp$basedriver$controller$DriverController = Activator.class$("org.apache.felix.upnp.basedriver.controller.DriverController")) : class$org$apache$felix$upnp$basedriver$controller$DriverController).getName(), (class$org$apache$felix$upnp$basedriver$controller$DevicesInfo == null ? (class$org$apache$felix$upnp$basedriver$controller$DevicesInfo = Activator.class$("org.apache.felix.upnp.basedriver.controller.DevicesInfo")) : class$org$apache$felix$upnp$basedriver$controller$DevicesInfo).getName()}, (Object)this.drvController, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

