/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.extra.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.felix.upnp.extra.util.EventSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPEventListener;
import org.osgi.service.upnp.UPnPLocalStateVariable;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;

public class UPnPEventNotifier
implements PropertyChangeListener,
ServiceListener {
    private BundleContext context;
    private UPnPDevice device;
    private UPnPService service;
    private String deviceId;
    private String serviceId;
    private Properties UPnPTargetListener;
    private Vector upnpListeners = new Vector();
    private final Object LOCK = new Object();
    static /* synthetic */ Class class$org$osgi$service$upnp$UPnPEventListener;

    public UPnPEventNotifier(BundleContext context, UPnPDevice device, UPnPService service, EventSource source) {
        this(context, device, service);
        UPnPStateVariable[] vars;
        if (source != null && (vars = service.getStateVariables()) != null) {
            for (int i = 0; i < vars.length; ++i) {
                if (!vars[i].sendsEvents()) continue;
                source.addPropertyChangeListener(vars[i].getName(), this);
            }
        }
    }

    public UPnPEventNotifier(BundleContext context, UPnPDevice device, UPnPService service) {
        this.context = context;
        this.device = device;
        this.service = service;
        this.setupUPnPListenerWatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupUPnPListenerWatcher() {
        Dictionary dict = this.device.getDescriptions(null);
        this.deviceId = (String)dict.get("UPnP.device.UDN");
        this.serviceId = this.service.getId();
        this.UPnPTargetListener = new Properties();
        this.UPnPTargetListener.put("UPnP.device.UDN", this.deviceId);
        this.UPnPTargetListener.put("UPnP.service.id", this.serviceId);
        this.UPnPTargetListener.put("UPnP.device.type", dict.get("UPnP.device.type"));
        this.UPnPTargetListener.put("UPnP.service.type", this.service.getType());
        String ANY_UPnPEventListener = "(objectClass=" + (class$org$osgi$service$upnp$UPnPEventListener == null ? (class$org$osgi$service$upnp$UPnPEventListener = UPnPEventNotifier.class$("org.osgi.service.upnp.UPnPEventListener")) : class$org$osgi$service$upnp$UPnPEventListener).getName() + ")";
        Object object = this.LOCK;
        synchronized (object) {
            try {
                String filter = ANY_UPnPEventListener;
                this.context.addServiceListener((ServiceListener)this, filter);
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
            ServiceReference[] listeners = null;
            try {
                listeners = this.context.getServiceReferences((class$org$osgi$service$upnp$UPnPEventListener == null ? (class$org$osgi$service$upnp$UPnPEventListener = UPnPEventNotifier.class$("org.osgi.service.upnp.UPnPEventListener")) : class$org$osgi$service$upnp$UPnPEventListener).getName(), null);
                if (listeners != null) {
                    for (int i = 0; i < listeners.length; ++i) {
                        ServiceReference sr = listeners[i];
                        Filter filter = (Filter)sr.getProperty("upnp.filter");
                        if (filter == null) {
                            this.upnpListeners.add(sr);
                            continue;
                        }
                        if (!filter.match((Dictionary)this.UPnPTargetListener)) continue;
                        this.addNewListener(sr);
                    }
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
            Properties status = this.getCurrentStatus();
            if (!status.isEmpty()) {
                this.doNotify(status);
            }
        }
    }

    private Properties getCurrentStatus() {
        Properties status = new Properties();
        UPnPStateVariable[] vars = this.service.getStateVariables();
        if (vars != null) {
            for (int i = 0; i < vars.length; ++i) {
                if (!vars[i].sendsEvents()) continue;
                if (vars[i] instanceof UPnPLocalStateVariable) {
                    UPnPLocalStateVariable localVar = (UPnPLocalStateVariable)vars[i];
                    String property = localVar.getName();
                    Object value = localVar.getCurrentValue();
                    status.put(property, value);
                    continue;
                }
                System.out.println("[Warning] The StateVariable (" + vars[i].getName() + ")" + " of device (ID:" + this.deviceId + ") " + "should implement the interface UPnPLocalStateVariable");
            }
        }
        return status;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        Object value = evt.getNewValue();
        Properties events = new Properties();
        events.put(property, value);
        this.doNotify(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify(Properties events) {
        Object object = this.LOCK;
        synchronized (object) {
            Iterator list = this.upnpListeners.iterator();
            while (list.hasNext()) {
                ServiceReference sr = (ServiceReference)list.next();
                new NotifierThread(sr, events).start();
            }
        }
    }

    private void doNotify(ServiceReference sr) {
        Properties status = this.getCurrentStatus();
        if (!status.isEmpty()) {
            new NotifierThread(sr, status).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent e) {
        ServiceReference sr = e.getServiceReference();
        Object object = this.LOCK;
        synchronized (object) {
            switch (e.getType()) {
                case 1: {
                    Filter filter = (Filter)sr.getProperty("upnp.filter");
                    if (filter == null) {
                        this.addNewListener(sr);
                        this.doNotify(sr);
                        break;
                    }
                    if (!filter.match((Dictionary)this.UPnPTargetListener)) break;
                    this.addNewListener(sr);
                    this.doNotify(sr);
                    break;
                }
                case 2: {
                    Filter filter = (Filter)sr.getProperty("upnp.filter");
                    this.removeListener(sr);
                    if (filter == null) {
                        this.addNewListener(sr);
                        break;
                    }
                    if (!filter.match((Dictionary)this.UPnPTargetListener)) break;
                    this.addNewListener(sr);
                    break;
                }
                case 4: {
                    this.removeListener(sr);
                }
            }
        }
    }

    private void removeListener(ServiceReference reference) {
        this.upnpListeners.remove(reference);
    }

    private void addNewListener(ServiceReference reference) {
        this.upnpListeners.add(reference);
    }

    public void destroy() {
        this.context.removeServiceListener((ServiceListener)this);
        this.upnpListeners.removeAllElements();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NotifierThread
    extends Thread {
        private ServiceReference sr;
        private Properties events;

        public NotifierThread(ServiceReference sr, Properties events) {
            super("UPnPEventNotifier");
            this.sr = sr;
            this.events = events;
        }

        public void run() {
            try {
                UPnPEventListener listener = (UPnPEventListener)UPnPEventNotifier.this.context.getService(this.sr);
                listener.notifyUPnPEvent(UPnPEventNotifier.this.deviceId, UPnPEventNotifier.this.serviceId, (Dictionary)this.events);
                UPnPEventNotifier.this.context.ungetService(this.sr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

