/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.apache.felix.webconsole.internal.servlet.JakartaServiceTracker;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.apache.felix.webconsole.internal.servlet.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class PluginHolder
implements ServiceTrackerCustomizer<Servlet, Plugin> {
    public static final String ATTR_FLAT_LABEL_MAP = PluginHolder.class.getName() + ".flatLabelMap";
    private final OsgiManager osgiManager;
    private final BundleContext bundleContext;
    private final Map<String, List<Plugin>> plugins = new HashMap<String, List<Plugin>>();
    private volatile ServletContext servletContext;
    private volatile String defaultPluginLabel;
    private final ServiceTracker<Servlet, Plugin> servletTracker;
    private volatile Closeable jakartaTracker;

    PluginHolder(OsgiManager osgiManager, BundleContext context) {
        this.osgiManager = osgiManager;
        this.bundleContext = context;
        Filter filter = null;
        try {
            filter = context.createFilter("(&(objectClass=javax.servlet.Servlet)(felix.webconsole.label=*))");
        }
        catch (InvalidSyntaxException e) {
            throw new InternalError("Failed creating filter: " + e.getMessage());
        }
        this.servletTracker = new ServiceTracker(context, filter, (ServiceTrackerCustomizer)this);
    }

    void open() {
        this.servletTracker.open();
        try {
            this.jakartaTracker = new JakartaServiceTracker(this, this.getBundleContext());
            this.osgiManager.log(3, "Jakarta Servlet bridge enabled");
        }
        catch (Throwable t) {
            this.osgiManager.log(3, "Jakarta Servlet bridge not enabled");
        }
    }

    void close() {
        if (this.jakartaTracker != null) {
            try {
                this.jakartaTracker.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jakartaTracker = null;
        }
        this.servletTracker.close();
        this.plugins.clear();
        this.servletContext = null;
        this.defaultPluginLabel = null;
    }

    String getDefaultPluginLabel() {
        return this.defaultPluginLabel;
    }

    void setDefaultPluginLabel(String defaultPluginLabel) {
        this.defaultPluginLabel = defaultPluginLabel;
    }

    void addInternalPlugin(String pluginClassName, String label) {
        Plugin.InternalPlugin plugin = new Plugin.InternalPlugin(this, this.osgiManager, pluginClassName, label);
        this.addPlugin(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInternalPlugin(String pluginClassName, String label) {
        Map<String, List<Plugin>> map = this.plugins;
        synchronized (map) {
            List<Plugin> list = this.plugins.get(label);
            if (list != null) {
                for (Plugin plugin : list) {
                    Plugin.InternalPlugin internalPlugin;
                    if (!(plugin instanceof Plugin.InternalPlugin) || !(internalPlugin = (Plugin.InternalPlugin)plugin).getId().equals(pluginClassName)) continue;
                    this.removePlugin(plugin);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractWebConsolePlugin getPlugin(String label) {
        AbstractWebConsolePlugin consolePlugin;
        block5: {
            Plugin p;
            block4: {
                Plugin plugin;
                consolePlugin = null;
                if (label == null || label.length() <= 0) break block4;
                Map<String, List<Plugin>> map = this.plugins;
                synchronized (map) {
                    List<Plugin> list = this.plugins.get(label);
                    plugin = list != null && !list.isEmpty() ? list.get(0) : null;
                }
                if (plugin == null) break block5;
                consolePlugin = plugin.getConsolePlugin();
                break block5;
            }
            List<Plugin> plugins = this.getPlugins();
            Iterator<Plugin> iterator = plugins.iterator();
            while (iterator.hasNext() && (consolePlugin = (p = iterator.next()).getConsolePlugin()) == null) {
            }
        }
        return consolePlugin;
    }

    Map getLocalizedLabelMap(ResourceBundleManager resourceBundleManager, Locale locale, String defaultCategory) {
        HashMap map = new HashMap();
        HashMap<String, String> flatMap = new HashMap<String, String>();
        List<Plugin> plugins = this.getPlugins();
        for (Plugin plugin : plugins) {
            if (!plugin.isEnabled()) continue;
            Map categoryMap = null;
            String category = plugin.getCategory();
            if (category == null || category.trim().length() == 0) {
                category = defaultCategory;
            }
            categoryMap = this.findCategoryMap(map, category);
            String label = plugin.getLabel();
            String title = plugin.getTitle();
            if (title.startsWith("%")) {
                try {
                    ResourceBundle resourceBundle = resourceBundleManager.getResourceBundle(plugin.getBundle(), locale);
                    title = resourceBundle.getString(title.substring(1));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            categoryMap.put(label, title);
            flatMap.put(label, title);
        }
        map.put(ATTR_FLAT_LABEL_MAP, flatMap);
        return map;
    }

    private Map findCategoryMap(Map map, String categoryPath) {
        Map categoryMap = null;
        Map searchMap = map;
        String[] categories = categoryPath.split("/");
        for (int i = 0; i < categories.length; ++i) {
            String categoryKey = "category." + categories[i];
            if (searchMap.containsKey(categoryKey)) {
                categoryMap = (Map)searchMap.get(categoryKey);
            } else {
                categoryMap = new HashMap();
                searchMap.put(categoryKey, categoryMap);
            }
            searchMap = categoryMap;
        }
        return categoryMap;
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    ServletContext getServletContext() {
        return this.servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Plugin> getPlugins() {
        ArrayList<Plugin> plugins;
        ArrayList<Plugin> arrayList = plugins = new ArrayList<Plugin>();
        synchronized (arrayList) {
            for (List<Plugin> c : this.plugins.values()) {
                if (c.isEmpty()) continue;
                plugins.add(c.get(0));
            }
        }
        return plugins;
    }

    public Plugin addingService(ServiceReference<Servlet> reference) {
        Plugin.ServletPlugin plugin = null;
        String label = Util.getStringProperty(reference, "felix.webconsole.label");
        if (label != null) {
            plugin = new Plugin.ServletPlugin(this, reference, label);
            this.addPlugin(plugin);
        }
        return plugin;
    }

    public void modifiedService(ServiceReference<Servlet> reference, Plugin plugin) {
        this.removedService(reference, plugin);
        this.addingService((ServiceReference)reference);
    }

    public void removedService(ServiceReference<Servlet> reference, Plugin plugin) {
        this.removePlugin(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPlugin(Plugin plugin) {
        Map<String, List<Plugin>> map = this.plugins;
        synchronized (map) {
            List list = this.plugins.computeIfAbsent(plugin.getLabel(), k -> new ArrayList());
            Plugin oldPlugin = list.isEmpty() ? null : (Plugin)list.get(0);
            list.add(plugin);
            Collections.sort(list);
            Collections.reverse(list);
            Plugin first = (Plugin)list.get(0);
            if (first == plugin) {
                if (!first.init()) {
                    list.remove(plugin);
                } else if (oldPlugin != null) {
                    this.osgiManager.log(2, "Overwriting existing plugin " + oldPlugin.getId() + " having label " + plugin.getLabel() + " with new plugin " + plugin.getId() + " due to higher ranking ");
                    oldPlugin.dispose();
                }
            }
            if (first == oldPlugin) {
                this.osgiManager.log(2, "Ignoring new plugin " + plugin.getId() + " having existing label " + plugin.getLabel() + " due to lower ranking than old plugin " + oldPlugin.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePlugin(Plugin plugin) {
        Map<String, List<Plugin>> map = this.plugins;
        synchronized (map) {
            List<Plugin> list = this.plugins.get(plugin.getLabel());
            if (list != null) {
                boolean isFirst = !list.isEmpty() && list.get(0) == plugin;
                list.remove(plugin);
                if (list.isEmpty()) {
                    this.plugins.remove(plugin.getLabel());
                } else if (isFirst) {
                    while (!list.isEmpty() && !list.get(0).init()) {
                        list.remove(0);
                    }
                }
            }
            plugin.dispose();
        }
    }
}

