////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

/**
 *  Number of pixels between the component's left border
 *  and the left edge of its content area.
 *  <p>The default value is 0.</p>
 *  <p>The default value for a Button control in the Halo theme is 10
 *     and in the Spark theme is 6.</p>
 *  <p>The default value for the ComboBox control is 5.</p>
 *  <p>The default value for the Form container is 16.</p>
 *  <p>The default value for the Tree control is 2.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="paddingLeft", type="Number", format="Length", inherit="no")]

/**
 *  Number of pixels between the component's right border
 *  and the right edge of its content area.
 *  <p>The default value is 0.</p>
 *  <p>The default value for a Button control in the Halo theme is 10
 *     and in the Spark theme is 6.</p>
 *  <p>The default value for the ComboBox control is 5.</p>
 *  <p>The default value for the Form container is 16.</p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 */
[Style(name="paddingRight", type="Number", format="Length", inherit="no")]
