/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedName
extends QName {
    public ObjectList<QName> type_params;
    private String fullname;
    private String namepart;

    public ParameterizedName(ObjectValue ns, String name, ObjectList<TypeValue> type_params) {
        super(ns, name);
        this.type_params = new ObjectList(type_params.size());
        for (TypeValue t : type_params) {
            this.type_params.add(t.name);
        }
    }

    public ParameterizedName(ObjectList<QName> type_names, ObjectValue ns, String name) {
        super(ns, name);
        this.type_params = type_names;
    }

    @Override
    public boolean equals(Object rhs) {
        if (rhs instanceof ParameterizedName && super.equals(rhs)) {
            ParameterizedName rp = (ParameterizedName)rhs;
            if (rp.type_params.size() == this.type_params.size()) {
                int limit = this.type_params.size();
                for (int i = 0; i < limit; ++i) {
                    if (this.type_params.at(i).equals(rp.type_params.at(1))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.ns.hashCode() + this.name.hashCode() + this.type_params.hashCode();
    }

    public String getNamePart() {
        if (this.namepart == null) {
            this.namepart = this.name;
            this.namepart = this.namepart + ".<";
            int limit = this.type_params.size();
            for (int i = 0; i < limit; ++i) {
                this.namepart = this.namepart + this.type_params.at(i).toString();
            }
            this.namepart = this.namepart + ">";
            this.namepart = this.namepart.intern();
        }
        return this.namepart;
    }

    @Override
    public String toString() {
        if (this.fullname == null) {
            this.fullname = this.ns != null && this.ns.name.length() != 0 ? (this.ns.name + ":" + this.getNamePart()).intern() : this.getNamePart();
        }
        return this.fullname;
    }
}

