/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.BindableInfo;
import flex2.compiler.as3.genext.GenerativeFirstPassEvaluator;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindableFirstPassEvaluator
extends GenerativeFirstPassEvaluator {
    private static final int BINDABLE_NONE = 0;
    private static final int BINDABLE_USER = 1;
    private static final int BINDABLE_CODEGEN_PROP = 2;
    private static final int BINDABLE_CODEGEN_CLASS = 3;
    private static final String STYLE = "style";
    private final Set metaData;
    private Set<DefinitionNode> bindableClasses;
    private Set<DefinitionNode> managedClasses;
    private Set<DefinitionNode> evaluatedClasses;
    private Map<String, BindableInfo> classMap;
    private ClassDefinitionNode currentClassNode = null;
    private BindableInfo bindableInfo;
    private Map<String, Integer> visitedProps;
    private boolean inFunction = false;

    public BindableFirstPassEvaluator(TypeTable typeTable, StandardDefs defs, Set metaData) {
        super(typeTable, defs);
        this.metaData = metaData;
        this.classMap = new LinkedHashMap<String, BindableInfo>();
        this.evaluatedClasses = new HashSet<DefinitionNode>();
    }

    @Override
    public Value evaluate(Context context, ProgramNode programNode) {
        for (MetaDataNode metaDataNode : this.metaData) {
            if (!"Managed".equals(metaDataNode.getId()) || !(metaDataNode.def instanceof ClassDefinitionNode)) continue;
            this.registerManagedClass(metaDataNode.def);
        }
        for (MetaDataNode metaDataNode : this.metaData) {
            if (!"Bindable".equals(metaDataNode.getId()) || !(metaDataNode.def instanceof ClassDefinitionNode)) continue;
            if (this.isManagedClass(metaDataNode.def)) {
                context.localizedWarning2(metaDataNode.pos(), (Object)new ClassBindableUnnecessaryOnManagedClass());
                continue;
            }
            if (BindableFirstPassEvaluator.getEventName(metaDataNode, context) != null) continue;
            this.registerBindableClass((ClassDefinitionNode)metaDataNode.def);
        }
        return super.evaluate(context, programNode);
    }

    @Override
    public Value evaluate(Context context, MetaDataNode metaDataNode) {
        if ("Bindable".equals(metaDataNode.getId()) && !(metaDataNode.def instanceof ClassDefinitionNode)) {
            if (metaDataNode.def instanceof FunctionDefinitionNode) {
                FunctionDefinitionNode node = (FunctionDefinitionNode)metaDataNode.def;
                if (!"true".equals(metaDataNode.getValue(STYLE))) {
                    if (BindableFirstPassEvaluator.getEventName(metaDataNode, context) == null) {
                        if (this.inManagedClass()) {
                            context.localizedWarning2(node.pos(), (Object)new PropertyBindableUnnecessaryOnManagedClass());
                        } else if (this.inBindableClass()) {
                            context.localizedWarning2(node.pos(), (Object)new PropertyBindableUnnecessaryOnBindableClass());
                        } else {
                            boolean isGetter = NodeMagic.functionIsGetter(node);
                            if (isGetter || NodeMagic.functionIsSetter(node)) {
                                if (this.checkBindableGetterSetter(context, node, false, false)) {
                                    this.registerBindableGetterSetter(context, node, true, isGetter);
                                }
                            } else {
                                context.localizedWarning2(node.pos(), (Object)new BindableFunctionRequiresEventName());
                            }
                        }
                    } else if (NodeMagic.functionIsGetter(node) || NodeMagic.functionIsSetter(node)) {
                        String name = NodeMagic.getFunctionName(node);
                        if (this.getVisitedGetterSetterBindType(name) == 3) {
                            QName qname = new QName(NodeMagic.getUserNamespace((DefinitionNode)node), name);
                            this.unregisterBindableAccessor(qname);
                        }
                        this.registerVisitedGetterSetter(name, 1);
                    }
                }
            } else if (metaDataNode.def instanceof VariableDefinitionNode) {
                VariableDefinitionNode node = (VariableDefinitionNode)metaDataNode.def;
                if (this.inFunction) {
                    context.localizedError2(node.pos(), (Object)new BindableNotAllowedInsideFunctionDefinition());
                } else if (BindableFirstPassEvaluator.getEventName(metaDataNode, context) == null) {
                    if (this.inManagedClass()) {
                        context.localizedWarning2(node.pos(), (Object)new PropertyBindableUnnecessaryOnManagedClass());
                    } else if (this.inBindableClass()) {
                        context.localizedWarning2(node.pos(), (Object)new PropertyBindableUnnecessaryOnBindableClass());
                    } else if (this.checkBindableVariable(context, node, false, false)) {
                        this.registerBindableVariable(context, node, true);
                    }
                }
            } else {
                context.localizedError2(metaDataNode.pos(), (Object)new BindableNotAllowedHere());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value evaluate(Context context, ClassDefinitionNode node) {
        if (!this.evaluatedClasses.contains(node)) {
            this.evaluatedClasses.add((DefinitionNode)node);
            try {
                this.setCurrentClass(context, node);
                if (node.statements != null) {
                    if (node.instanceinits != null) {
                        for (Node instanceinit : node.instanceinits) {
                            instanceinit.evaluate(context, (Evaluator)this);
                        }
                    }
                    node.statements.evaluate(context, (Evaluator)this);
                }
                if (this.bindableInfo != null) {
                    this.bindableInfo.setClassName(NodeMagic.getUnqualifiedClassName(node));
                    this.classMap.put(NodeMagic.getClassName(node), this.bindableInfo);
                    NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.CLASS_EVENT));
                    NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.CLASS_EVENTDISPATCHER));
                    NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.INTERFACE_IEVENTDISPATCHER));
                    NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.CLASS_BINDINGMANAGER));
                }
                Object var6_5 = null;
                this.setCurrentClass(context, null);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.setCurrentClass(context, null);
                throw throwable;
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, FunctionDefinitionNode node) {
        boolean isGetter;
        String name = NodeMagic.getFunctionName(node);
        if (this.inBindableClass() && ((isGetter = NodeMagic.functionIsGetter(node)) || NodeMagic.functionIsSetter(node)) && this.getVisitedGetterSetterBindType(name) != 1) {
            this.registerBindableGetterSetter(context, node, false, isGetter);
        }
        this.inFunction = true;
        super.evaluate(context, node);
        this.inFunction = false;
        return null;
    }

    @Override
    public Value evaluate(Context context, VariableDefinitionNode node) {
        QName qname = new QName(NodeMagic.getUserNamespace((DefinitionNode)node), NodeMagic.getVariableName(node));
        if (this.inBindableClass() && !this.inFunction && !this.isBindableAccessor(qname) && this.checkBindableVariable(context, node, true, true)) {
            this.registerBindableVariable(context, node, false);
        }
        return null;
    }

    private boolean checkBindableVariable(Context context, VariableDefinitionNode def, boolean quiet, boolean publicOnly) {
        Object item;
        if (!this.inClass()) {
            if (!quiet) {
                context.localizedError2(def.pos(), (Object)new BindableNotAllowedOnGlobalOrPackageVariables());
            }
            return false;
        }
        if (def.list != null && def.list.items != null && def.list.items.size() > 0 && (item = def.list.items.get(0)) instanceof VariableBindingNode) {
            VariableBindingNode variableBinding = (VariableBindingNode)item;
            if (variableBinding.kind == -65) {
                if (!quiet) {
                    context.localizedError2(def.pos(), (Object)new BindableNotAllowedOnConstMemberVariables());
                }
                return false;
            }
        }
        if (publicOnly && (def.attrs == null || !def.attrs.hasAttribute("public"))) {
            if (!quiet) {
                context.localizedError2(def.pos(), (Object)new BindableNotAllowedHereOnNonPublicMemberVariables());
            }
            return false;
        }
        return true;
    }

    private boolean checkBindableGetterSetter(Context context, FunctionDefinitionNode def, boolean quiet, boolean publicOnly) {
        if (!this.inClass()) {
            if (!quiet) {
                context.localizedError2(def.pos(), (Object)new BindableNotAllowedOnGlobalOrPackageFunctions());
            }
            return false;
        }
        if (publicOnly && (def.attrs == null || !def.attrs.hasAttribute("public"))) {
            if (!quiet) {
                context.localizedError2(def.pos(), (Object)new BindableNotAllowedHereOnNonPublicFunctions());
            }
            return false;
        }
        return true;
    }

    private void setCurrentClass(Context context, ClassDefinitionNode node) {
        this.currentClassNode = node;
        this.visitedProps = null;
        this.bindableInfo = this.isBindableClass((DefinitionNode)this.currentClassNode) ? new BindableInfo(context, this.typeTable.getSymbolTable()) : null;
    }

    private boolean inClass() {
        return this.currentClassNode != null;
    }

    private boolean inManagedClass() {
        return this.inClass() && this.isManagedClass((DefinitionNode)this.currentClassNode);
    }

    private boolean inBindableClass() {
        return this.inClass() && this.isBindableClass((DefinitionNode)this.currentClassNode);
    }

    private void registerBindableClass(ClassDefinitionNode def) {
        (this.bindableClasses != null ? this.bindableClasses : (this.bindableClasses = new HashSet<DefinitionNode>())).add((DefinitionNode)def);
    }

    private boolean isBindableClass(DefinitionNode def) {
        return this.bindableClasses != null && this.bindableClasses.contains(def);
    }

    public void registerBindableVariable(Context context, ClassDefinitionNode classNode, VariableDefinitionNode varNode) {
        BindableInfo bInfo = this.classMap.get(NodeMagic.getClassName(classNode));
        if (bInfo == null) {
            bInfo = new BindableInfo(context, this.typeTable.getSymbolTable());
            bInfo.setClassName(NodeMagic.getUnqualifiedClassName(classNode));
            this.classMap.put(NodeMagic.getClassName(classNode), bInfo);
            NodeMagic.addImport(context, classNode, NameFormatter.toDot(this.standardDefs.CLASS_EVENT));
            NodeMagic.addImport(context, classNode, NameFormatter.toDot(this.standardDefs.CLASS_EVENTDISPATCHER));
            NodeMagic.addImport(context, classNode, NameFormatter.toDot(this.standardDefs.INTERFACE_IEVENTDISPATCHER));
            NodeMagic.addImport(context, classNode, NameFormatter.toDot(this.standardDefs.CLASS_BINDINGMANAGER));
        }
        assert (!varNode.attrs.hasAttribute("static"));
        bInfo.addAccessorVariable(varNode, false);
    }

    private void registerBindableVariable(Context context, VariableDefinitionNode node, boolean propLevel) {
        if (this.bindableInfo == null) {
            this.bindableInfo = new BindableInfo(context, this.typeTable.getSymbolTable());
        }
        if (node.attrs != null && node.attrs.hasAttribute("static")) {
            this.bindableInfo.setRequiresStaticEventDispatcher(true);
        }
        this.bindableInfo.addAccessorVariable(node, propLevel);
    }

    private void registerBindableGetterSetter(Context context, FunctionDefinitionNode node, boolean propLevel, boolean isGetter) {
        if (this.bindableInfo == null) {
            this.bindableInfo = new BindableInfo(context, this.typeTable.getSymbolTable());
        }
        if (node.attrs != null && node.attrs.hasAttribute("static")) {
            this.bindableInfo.setRequiresStaticEventDispatcher(true);
        }
        this.bindableInfo.addAccessorFunction(node, propLevel, isGetter);
        this.registerVisitedGetterSetter(NodeMagic.getFunctionName(node), propLevel ? 2 : 3);
    }

    private void unregisterBindableAccessor(QName qname) {
        if (this.bindableInfo != null) {
            this.bindableInfo.removeAccessor(qname);
        }
    }

    private boolean isBindableAccessor(QName qname) {
        return this.bindableInfo != null && this.bindableInfo.hasAccessor(qname);
    }

    private void registerManagedClass(DefinitionNode def) {
        (this.managedClasses != null ? this.managedClasses : (this.managedClasses = new HashSet<DefinitionNode>())).add(def);
    }

    private boolean isManagedClass(DefinitionNode def) {
        return this.managedClasses != null && this.managedClasses.contains(def);
    }

    private void registerVisitedGetterSetter(String name, int bindType) {
        (this.visitedProps != null ? this.visitedProps : (this.visitedProps = new HashMap<String, Integer>())).put(name, new Integer(bindType));
    }

    private int getVisitedGetterSetterBindType(String name) {
        return this.visitedProps == null || !this.visitedProps.containsKey(name) ? 0 : this.visitedProps.get(name);
    }

    public Map<String, BindableInfo> getClassMap() {
        return this.classMap != null ? this.classMap : Collections.emptyMap();
    }

    @Override
    public boolean makeSecondPass() {
        return this.classMap != null && this.classMap.size() > 0;
    }

    private static String getEventName(MetaDataNode node, Context context) {
        String eventName = node.getValue("event");
        if (eventName == null && node.count() == 1) {
            eventName = node.getValue(0);
        }
        if (eventName != null && !TextParser.isValidIdentifier(eventName)) {
            context.localizedError2(node.pos(), (Object)new EventNameNotValid());
        }
        return eventName;
    }

    public static class EventNameNotValid
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3786463371533992541L;
    }

    public static class BindableNotAllowedHereOnNonPublicFunctions
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2691841106860119387L;
    }

    public static class BindableNotAllowedOnGlobalOrPackageFunctions
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 1325086298753296115L;
    }

    public static class BindableNotAllowedHereOnNonPublicMemberVariables
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 1242538769384014352L;
    }

    public static class BindableNotAllowedOnStaticMemberVariables
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -912748026548162244L;
    }

    public static class BindableNotAllowedOnConstMemberVariables
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6790403636487031318L;
    }

    public static class BindableNotAllowedOnGlobalOrPackageVariables
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4467324380515362675L;
    }

    public static class BindableNotAllowedHere
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4321459267717857499L;
    }

    public static class BindableNotAllowedInsideFunctionDefinition
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6225358794137597473L;
    }

    public static class BindableFunctionRequiresEventName
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -158997496711365923L;
    }

    public static class PropertyBindableUnnecessaryOnBindableClass
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 8676289663338335097L;
    }

    public static class PropertyBindableUnnecessaryOnManagedClass
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 5345954896036961112L;
    }

    public static class ClassBindableUnnecessaryOnManagedClass
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -4120994886934453698L;
    }
}

