/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.builder.tags;

import flash.graphics.images.JPEGImage;
import flash.swf.builder.tags.ImageShapeBuilder;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.PlaceObject;
import flash.swf.types.Matrix;
import flash.swf.types.TagList;
import java.io.IOException;

public class DefineBitsBuilder {
    private DefineBitsBuilder() {
    }

    public static DefineBits build(JPEGImage image) throws IOException {
        DefineBits defineBits = new DefineBits(21);
        try {
            defineBits.data = image.getData();
        }
        finally {
            image.dispose();
        }
        return defineBits;
    }

    public static DefineBits build(String name, JPEGImage image) {
        DefineBits defineBits = null;
        try {
            defineBits = DefineBitsBuilder.build(image);
            defineBits.name = name;
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading JPEG image " + image.getLocation() + ". " + ex.getMessage());
        }
        finally {
            image.dispose();
        }
        return defineBits;
    }

    public static DefineSprite buildSprite(String name, JPEGImage image) {
        TagList taglist = new TagList();
        try {
            DefineBits defineBits = DefineBitsBuilder.build(image);
            taglist.defineBitsJPEG2(defineBits);
            DefineShape ds3 = ImageShapeBuilder.buildImage(defineBits, image.getWidth(), image.getHeight());
            taglist.defineShape3(ds3);
            PlaceObject po2 = new PlaceObject(ds3, 1);
            po2.setMatrix(new Matrix());
            taglist.placeObject2(po2);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading JPEG image " + image.getLocation() + ". " + ex.getMessage());
        }
        finally {
            image.dispose();
        }
        return DefineBitsBuilder.defineSprite(name, taglist);
    }

    private static DefineSprite defineSprite(String name, TagList taglist) {
        DefineSprite defineSprite = new DefineSprite();
        defineSprite.framecount = 1;
        defineSprite.tagList = taglist;
        defineSprite.name = name;
        return defineSprite;
    }
}

