/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.batik.anim.timing;

import java.util.Calendar;
import java.util.LinkedList;
import org.apache.flex.forks.batik.anim.timing.AccesskeyTimingSpecifier;
import org.apache.flex.forks.batik.anim.timing.EventbaseTimingSpecifier;
import org.apache.flex.forks.batik.anim.timing.IndefiniteTimingSpecifier;
import org.apache.flex.forks.batik.anim.timing.MediaMarkerTimingSpecifier;
import org.apache.flex.forks.batik.anim.timing.OffsetTimingSpecifier;
import org.apache.flex.forks.batik.anim.timing.RepeatTimingSpecifier;
import org.apache.flex.forks.batik.anim.timing.SyncbaseTimingSpecifier;
import org.apache.flex.forks.batik.anim.timing.TimedElement;
import org.apache.flex.forks.batik.anim.timing.TimingSpecifier;
import org.apache.flex.forks.batik.anim.timing.WallclockTimingSpecifier;
import org.apache.flex.forks.batik.parser.DefaultTimingSpecifierListHandler;
import org.apache.flex.forks.batik.parser.TimingSpecifierListParser;

public class TimingSpecifierListProducer
extends DefaultTimingSpecifierListHandler {
    protected LinkedList timingSpecifiers = new LinkedList();
    protected TimedElement owner;
    protected boolean isBegin;

    public TimingSpecifierListProducer(TimedElement owner, boolean isBegin) {
        this.owner = owner;
        this.isBegin = isBegin;
    }

    public TimingSpecifier[] getTimingSpecifiers() {
        return this.timingSpecifiers.toArray(new TimingSpecifier[0]);
    }

    public static TimingSpecifier[] parseTimingSpecifierList(TimedElement owner, boolean isBegin, String spec, boolean useSVG11AccessKeys, boolean useSVG12AccessKeys) {
        TimingSpecifierListParser p = new TimingSpecifierListParser(useSVG11AccessKeys, useSVG12AccessKeys);
        TimingSpecifierListProducer pp = new TimingSpecifierListProducer(owner, isBegin);
        p.setTimingSpecifierListHandler(pp);
        p.parse(spec);
        TimingSpecifier[] specs = pp.getTimingSpecifiers();
        return specs;
    }

    @Override
    public void offset(float offset) {
        OffsetTimingSpecifier ts = new OffsetTimingSpecifier(this.owner, this.isBegin, offset);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void syncbase(float offset, String syncbaseID, String timeSymbol) {
        SyncbaseTimingSpecifier ts = new SyncbaseTimingSpecifier(this.owner, this.isBegin, offset, syncbaseID, timeSymbol.charAt(0) == 'b');
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void eventbase(float offset, String eventbaseID, String eventType) {
        EventbaseTimingSpecifier ts = new EventbaseTimingSpecifier(this.owner, this.isBegin, offset, eventbaseID, eventType);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void repeat(float offset, String syncbaseID) {
        RepeatTimingSpecifier ts = new RepeatTimingSpecifier(this.owner, this.isBegin, offset, syncbaseID);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void repeat(float offset, String syncbaseID, int repeatIteration) {
        RepeatTimingSpecifier ts = new RepeatTimingSpecifier(this.owner, this.isBegin, offset, syncbaseID, repeatIteration);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void accesskey(float offset, char key) {
        AccesskeyTimingSpecifier ts = new AccesskeyTimingSpecifier(this.owner, this.isBegin, offset, key);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void accessKeySVG12(float offset, String keyName) {
        AccesskeyTimingSpecifier ts = new AccesskeyTimingSpecifier(this.owner, this.isBegin, offset, keyName);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void mediaMarker(String syncbaseID, String markerName) {
        MediaMarkerTimingSpecifier ts = new MediaMarkerTimingSpecifier(this.owner, this.isBegin, syncbaseID, markerName);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void wallclock(Calendar time) {
        WallclockTimingSpecifier ts = new WallclockTimingSpecifier(this.owner, this.isBegin, time);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void indefinite() {
        IndefiniteTimingSpecifier ts = new IndefiniteTimingSpecifier(this.owner, this.isBegin);
        this.timingSpecifiers.add(ts);
    }
}

