/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.batik.dom.svg;

import java.util.LinkedList;
import org.apache.flex.forks.batik.anim.values.AnimatableValue;
import org.apache.flex.forks.batik.dom.svg.AbstractElement;
import org.apache.flex.forks.batik.dom.svg.AnimatedAttributeListener;
import org.apache.flex.forks.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.flex.forks.batik.dom.svg.SVGOMElement;

public abstract class AbstractSVGAnimatedValue
implements AnimatedLiveAttributeValue {
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected boolean hasAnimVal;
    protected LinkedList listeners = new LinkedList();

    public AbstractSVGAnimatedValue(AbstractElement elt, String ns, String ln) {
        this.element = elt;
        this.namespaceURI = ns;
        this.localName = ln;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public boolean isSpecified() {
        return this.hasAnimVal || this.element.hasAttributeNS(this.namespaceURI, this.localName);
    }

    protected abstract void updateAnimatedValue(AnimatableValue var1);

    @Override
    public void addAnimatedAttributeListener(AnimatedAttributeListener aal) {
        if (!this.listeners.contains(aal)) {
            this.listeners.add(aal);
        }
    }

    @Override
    public void removeAnimatedAttributeListener(AnimatedAttributeListener aal) {
        this.listeners.remove(aal);
    }

    protected void fireBaseAttributeListeners() {
        if (this.element instanceof SVGOMElement) {
            ((SVGOMElement)this.element).fireBaseAttributeListeners(this.namespaceURI, this.localName);
        }
    }

    protected void fireAnimatedAttributeListeners() {
        for (AnimatedAttributeListener listener : this.listeners) {
            listener.animatedAttributeChanged(this.element, this);
        }
    }
}

