/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.ChangeEvent;
import flex2.compiler.as3.binding.PropertyWatcher;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.util.NameFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Watcher {
    protected Map<Object, Watcher> childWatchers;
    private int id;
    private Watcher parent;
    private boolean isPartOfAnonObjectGraph;
    private Set<ChangeEvent> changeEvents;
    private boolean shouldWriteChildren;
    private boolean operation;
    private String className;
    private Set<BindingExpression> bindingExpressions;
    protected static final ChangeEvent NO_CHANGE_EVENT = new ChangeEvent("__NoChangeEvent__", true);

    public Watcher(int id) {
        this.id = id;
        this.childWatchers = new HashMap<Object, Watcher>();
        this.isPartOfAnonObjectGraph = false;
        this.changeEvents = new HashSet<ChangeEvent>();
        this.shouldWriteChildren = true;
    }

    public void addBindingExpression(BindingExpression bindingExpression) {
        if (this.bindingExpressions == null) {
            this.bindingExpressions = new TreeSet<BindingExpression>();
        }
        this.bindingExpressions.add(bindingExpression);
    }

    public Set<BindingExpression> getBindingExpressions() {
        return this.bindingExpressions;
    }

    public Set<ChangeEvent> getChangeEvents() {
        return this.changeEvents;
    }

    public String getClassName() {
        return this.className;
    }

    public int getId() {
        return this.id;
    }

    public Watcher getParent() {
        return this.parent;
    }

    public boolean shouldWriteChildren() {
        return this.shouldWriteChildren;
    }

    public boolean isPartOfAnonObjectGraph() {
        return this.isPartOfAnonObjectGraph;
    }

    public void setPartOfAnonObjectGraph(boolean isPartOfAnonObjectGraph) {
        this.isPartOfAnonObjectGraph = isPartOfAnonObjectGraph;
    }

    public void setShouldWriteChildren(boolean shouldWriteChildren) {
        this.shouldWriteChildren = shouldWriteChildren;
    }

    public boolean shouldWriteSelf() {
        return true;
    }

    public void addChild(Watcher child) {
        if (child instanceof PropertyWatcher) {
            this.childWatchers.put(((PropertyWatcher)child).getProperty(), child);
        } else {
            this.childWatchers.put(new Integer(child.id), child);
        }
        child.parent = this;
    }

    public PropertyWatcher getChild(String property) {
        if (this.childWatchers.containsKey(property)) {
            return (PropertyWatcher)this.childWatchers.get(property);
        }
        return null;
    }

    public Collection<Watcher> getChildren() {
        return this.childWatchers.values();
    }

    public void addChangeEvent(String name) {
        this.addChangeEvent(name, true);
    }

    public void addChangeEvent(String name, boolean validate) {
        this.changeEvents.add(new ChangeEvent(name, validate));
    }

    public void addNoChangeEvent() {
        this.changeEvents.add(NO_CHANGE_EVENT);
    }

    public boolean isOperation() {
        return this.operation;
    }

    public void setClassName(String className) {
        this.className = NameFormatter.toDot(className);
    }

    public void setOperation(boolean operation) {
        this.operation = operation;
    }
}

