/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.io;

import flex2.compiler.io.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResourceFile
implements VirtualFile {
    private Map<String, VirtualFile> files;
    private Map<String, VirtualFile> roots;
    private String name;
    private String currentLocale;
    private String defaultLocale;
    private String[] locales;
    private VirtualFile defaultFile;
    private VirtualFile defaultRoot;

    public ResourceFile(String name, String[] locales, VirtualFile[] files, VirtualFile[] pathRoots) {
        this.name = name;
        this.files = new LinkedHashMap<String, VirtualFile>();
        this.roots = new LinkedHashMap<String, VirtualFile>();
        this.locales = new String[locales == null ? 0 : locales.length];
        int len = this.locales.length;
        for (int i = 0; i < len; ++i) {
            this.locales[i] = locales[i];
            if (locales[i] == null) continue;
            this.files.put(locales[i], files[i]);
            this.roots.put(locales[i], pathRoots[i]);
        }
        this.setDefault();
    }

    private void setDefault() {
        this.defaultLocale = null;
        this.defaultFile = null;
        this.defaultRoot = null;
        this.currentLocale = null;
        int len = this.locales.length;
        for (int i = 0; i < len; ++i) {
            if (this.locales[i] == null || this.files.get(this.locales[i]) == null || this.defaultLocale != null || this.defaultFile != null || this.defaultRoot != null) continue;
            this.defaultLocale = this.locales[i];
            this.defaultFile = this.files.get(this.locales[i]);
            this.defaultRoot = this.roots.get(this.locales[i]);
            break;
        }
        this.currentLocale = this.locales == null || this.locales.length == 0 ? null : this.locales[0];
    }

    public void merge(ResourceFile f) {
        if (f != null) {
            int len;
            int n = len = this.locales == null ? 0 : this.locales.length;
            for (int i = 0; i < len; ++i) {
                String locale = this.locales[i];
                VirtualFile obj1 = this.files.get(locale);
                VirtualFile obj2 = f.files.get(locale);
                if (obj1 != null || obj2 == null) continue;
                this.files.put(locale, obj2);
                this.roots.put(locale, obj2);
            }
            this.setDefault();
        }
    }

    public void setLocale(String locale) {
        this.currentLocale = locale;
    }

    public String getName() {
        return this.name;
    }

    public String getNameForReporting() {
        VirtualFile f = this.getVirtualFile();
        return f == null ? this.getName() : f.getNameForReporting();
    }

    public String getURL() {
        VirtualFile f = this.getVirtualFile();
        return f == null ? null : f.getURL();
    }

    public String getParent() {
        VirtualFile f = this.getVirtualFile();
        return f == null ? null : f.getParent();
    }

    public boolean isDirectory() {
        VirtualFile f = this.getVirtualFile();
        return f == null ? false : f.isDirectory();
    }

    public long size() {
        VirtualFile f = this.getVirtualFile();
        return f == null ? 0L : f.size();
    }

    public String getMimeType() {
        VirtualFile f = this.getVirtualFile();
        return f == null ? null : f.getMimeType();
    }

    public InputStream getInputStream() throws IOException {
        VirtualFile f = this.getVirtualFile();
        return f == null ? null : f.getInputStream();
    }

    public byte[] toByteArray() throws IOException {
        VirtualFile f = this.getVirtualFile();
        return f == null ? null : f.toByteArray();
    }

    public long getLastModified() {
        long ts = -1L;
        for (String locale : this.files.keySet()) {
            VirtualFile f = this.files.get(locale);
            if (f == null || f.getLastModified() <= ts) continue;
            ts = f.getLastModified();
        }
        return ts;
    }

    public VirtualFile resolve(String relativeStr) {
        VirtualFile f = this.getVirtualFile();
        return f == null ? null : f.resolve(relativeStr);
    }

    public void close() {
        VirtualFile f = this.getVirtualFile();
        if (f != null) {
            f.close();
        }
    }

    public boolean equals(Object obj) {
        VirtualFile f = this.getVirtualFile();
        return f == null ? obj == null : f.equals(obj);
    }

    public int hashCode() {
        VirtualFile f = this.getVirtualFile();
        return f == null ? -1 : f.hashCode();
    }

    public boolean isTextBased() {
        VirtualFile f = this.getVirtualFile();
        return f == null ? false : f.isTextBased();
    }

    private VirtualFile getVirtualFile() {
        if (this.currentLocale == null) {
            return this.defaultFile;
        }
        VirtualFile f = this.files.get(this.currentLocale);
        if (f == null) {
            return this.defaultFile;
        }
        return f;
    }

    public VirtualFile getResourcePathRoot() {
        if (this.currentLocale == null) {
            return this.defaultRoot;
        }
        VirtualFile f = this.roots.get(this.currentLocale);
        if (f == null) {
            return this.defaultRoot;
        }
        return f;
    }

    public VirtualFile getResourceFile() {
        return this.getVirtualFile();
    }

    public VirtualFile[] getResourceFiles() {
        VirtualFile[] list = new VirtualFile[this.files.size()];
        int j = 0;
        for (String locale : this.files.keySet()) {
            list[j] = this.files.get(locale);
            ++j;
        }
        return list;
    }

    public VirtualFile[] getResourcePathRoots() {
        VirtualFile[] list = new VirtualFile[this.roots.size()];
        int j = 0;
        for (String locale : this.roots.keySet()) {
            list[j] = this.roots.get(locale);
            ++j;
        }
        return list;
    }

    public boolean complete() {
        int len = this.locales.length;
        for (int i = 0; i < len; ++i) {
            if (this.files.get(this.locales[i]) != null) continue;
            return false;
        }
        return true;
    }
}

