/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcComponent;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcFile;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcGroup {
    private Map<String, Swc> swcs;
    private SwcGroup rslGroup;
    private NameMappings nameMappings = new NameMappings();
    private Map<String, VirtualFile> files = new HashMap<String, VirtualFile>();
    private Set<QName> qnames;
    private Map<String, SwcScript> def2script;
    private Map<SwcScript, String> obsoleted = new HashMap<SwcScript, String>();

    SwcGroup(Map<String, Swc> swcs) {
        this.swcs = swcs;
        this.rslGroup = null;
        this.updateNameMappings();
        this.updateFiles();
        this.updateMaps();
    }

    SwcGroup(Map<String, Swc> swcs, SwcGroup rslGroup) {
        this.swcs = swcs;
        this.rslGroup = rslGroup;
        this.updateNameMappings();
        this.updateFiles();
        this.updateMaps();
    }

    public int getNumberLoaded() {
        return this.swcs.size();
    }

    public NameMappings getNameMappings() {
        return this.nameMappings;
    }

    public Map<String, SwcScript> getScriptMap() {
        return this.def2script;
    }

    public Set<QName> getQNames() {
        return this.qnames;
    }

    public Map<String, VirtualFile> getFiles() {
        return this.files;
    }

    public VirtualFile getFile(String name) {
        Swc swc;
        VirtualFile swcFile = null;
        String location = SwcFile.getSwcLocation(name);
        String fileName = SwcFile.getFilePath(name);
        if (location != null && fileName != null && (swc = this.swcs.get(location)) != null) {
            swcFile = swc.getFile(fileName);
        }
        return swcFile;
    }

    public Swc getSwc(String name) {
        if (name == null) {
            throw new NullPointerException("getSwc: name may not be null");
        }
        return this.swcs.get(name);
    }

    public Map<String, Swc> getSwcs() {
        return this.swcs;
    }

    public List<Long> getSwcTimes() {
        ArrayList<Long> lastModified = new ArrayList<Long>();
        for (Swc swc : this.swcs.values()) {
            lastModified.add(new Long(swc.getLastModified()));
        }
        return lastModified;
    }

    public Map<SwcScript, String> getObsoleted() {
        return this.obsoleted;
    }

    public void close() {
        for (Swc swc : this.swcs.values()) {
            swc.close();
        }
    }

    private void updateNameMappings() {
        for (Swc swc : this.swcs.values()) {
            Iterator<SwcComponent> iter2 = swc.getComponentIterator();
            while (iter2.hasNext()) {
                boolean success;
                SwcComponent component = iter2.next();
                String namespaceURI = component.getUri();
                String name = component.getName();
                if (namespaceURI == null) continue;
                if ("".equals(namespaceURI)) {
                    if (name == null) continue;
                    SwcException.EmptyNamespace e = new SwcException.EmptyNamespace(name);
                    ThreadLocalToolkit.log(e);
                    throw e;
                }
                String className = component.getClassName();
                if (name == null) {
                    name = NameFormatter.retrieveClassName(className);
                }
                if (success = this.nameMappings.addClass(namespaceURI, name, className)) continue;
                SwcException.ComponentDefinedTwice e = new SwcException.ComponentDefinedTwice(name, className, this.nameMappings.lookupClassName(namespaceURI, name));
                ThreadLocalToolkit.log(e);
                throw e;
            }
        }
    }

    private void updateFiles() {
        for (Swc swc : this.swcs.values()) {
            Map<String, VirtualFile> catalogFiles = swc.getCatalogFiles();
            if (catalogFiles == null) continue;
            for (VirtualFile file : catalogFiles.values()) {
                VirtualFile curFile;
                String name = file.getName();
                String swcName = SwcFile.getFilePath(name);
                if (swcName != null) {
                    name = swcName;
                }
                if ((curFile = this.files.get(name)) != null && file.getLastModified() <= curFile.getLastModified()) continue;
                this.files.put(name, file);
            }
        }
    }

    private void updateMaps() {
        ArrayList<SwcScript> scriptList = new ArrayList<SwcScript>();
        for (Swc swc : this.swcs.values()) {
            Iterator<SwcLibrary> libit = swc.getLibraryIterator();
            while (libit.hasNext()) {
                SwcLibrary lib = libit.next();
                Iterator<SwcScript> scriptit = lib.getScriptIterator();
                while (scriptit.hasNext()) {
                    SwcScript script = scriptit.next();
                    scriptList.add(script);
                }
            }
        }
        SwcScript[] scriptArray = scriptList.toArray(new SwcScript[scriptList.size()]);
        Arrays.sort(scriptArray, new Comparator<SwcScript>(){

            @Override
            public int compare(SwcScript swcScript1, SwcScript swcScript2) {
                long swcScript2mod;
                long swcScript1mod = swcScript1.getLastModified();
                if (swcScript1mod == (swcScript2mod = swcScript2.getLastModified())) {
                    if (SwcGroup.this.rslGroup != null) {
                        boolean script1IsInRsl = SwcGroup.this.rslGroup.getSwcs().containsKey(swcScript1.getSwcLocation());
                        boolean script2IsInRsl = SwcGroup.this.rslGroup.getSwcs().containsKey(swcScript2.getSwcLocation());
                        if (script1IsInRsl && !script2IsInRsl) {
                            return -1;
                        }
                        if (!script1IsInRsl && script2IsInRsl) {
                            return 1;
                        }
                    }
                    CompilationUnit swcScript1CompilationUnit = swcScript1.getCompilationUnit();
                    CompilationUnit swcScript2CompilationUnit = swcScript2.getCompilationUnit();
                    if (swcScript1CompilationUnit != null) {
                        if (swcScript1CompilationUnit.hasTypeInfo) {
                            return -1;
                        }
                    } else if (swcScript2CompilationUnit != null && swcScript2CompilationUnit.hasTypeInfo) {
                        return 1;
                    }
                    return 0;
                }
                if (swcScript1mod < swcScript2mod) {
                    return 1;
                }
                return -1;
            }
        });
        this.def2script = new HashMap<String, SwcScript>();
        this.qnames = new HashSet<QName>();
        for (int i = 0; i < scriptArray.length; ++i) {
            SwcScript s = scriptArray[i];
            String name = s.getName();
            HashMap<String, SwcScript> staging = new HashMap<String, SwcScript>();
            Iterator<String> defit = s.getDefinitionIterator();
            while (defit.hasNext()) {
                CompilationUnit newerCompilationUnit;
                String def = defit.next();
                staging.put(def, s);
                SwcScript newerSwcScript = this.def2script.get(def);
                if (newerSwcScript == null) continue;
                staging = null;
                CompilationUnit compilationUnit = s.getCompilationUnit();
                if (compilationUnit == null || (newerCompilationUnit = newerSwcScript.getCompilationUnit()) == null || newerCompilationUnit == null || compilationUnit.typeInfo == newerCompilationUnit.typeInfo) break;
                this.obsoleted.put(s, newerSwcScript.getLibrary().getSwcLocation());
                break;
            }
            if (staging == null) continue;
            for (Map.Entry entry : staging.entrySet()) {
                String def = (String)entry.getKey();
                this.qnames.add(new QName(def));
                this.def2script.put(def, (SwcScript)entry.getValue());
                if (!Trace.swc) continue;
                Trace.trace((String)("Using " + def + " from " + s));
            }
        }
    }
}

