/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.messaging.FlexContext;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlushResult;
import flex.messaging.client.PollFlushResult;
import flex.messaging.client.PollWaitListener;
import flex.messaging.config.ConfigMap;
import flex.messaging.endpoints.BaseHTTPEndpoint;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.util.UserAgentManager;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BasePollingHTTPEndpoint
extends BaseHTTPEndpoint
implements PollWaitListener {
    private static final String POLLING_ENABLED = "polling-enabled";
    private static final String POLLING_INTERVAL_MILLIS = "polling-interval-millis";
    private static final String POLLING_INTERVAL_SECONDS = "polling-interval-seconds";
    private static final String MAX_WAITING_POLL_REQUESTS = "max-waiting-poll-requests";
    private static final String WAIT_INTERVAL_MILLIS = "wait-interval-millis";
    private static final String CLIENT_WAIT_INTERVAL_MILLIS = "client-wait-interval-millis";
    private static final int DEFAULT_WAIT_FOR_EXCESS_POLL_WAIT_CLIENTS = 3000;
    private UserAgentManager userAgentManager = new UserAgentManager();
    private volatile boolean canWait;
    protected final Object lock = new Object();
    private boolean waitEnabled;
    protected int waitingPollRequestsCount;
    private ConcurrentHashMap currentWaitedRequests;
    protected int clientWaitInterval = 0;
    protected int maxWaitingPollRequests = 0;
    protected boolean piggybackingEnabled;
    protected boolean pollingEnabled;
    protected long pollingIntervalMillis = -1L;
    protected long waitInterval = 0L;

    public BasePollingHTTPEndpoint() {
        this(false);
    }

    public BasePollingHTTPEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    @Override
    public void initialize(String id, ConfigMap properties) {
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            UserAgentManager.setupUserAgentManager(null, this.userAgentManager);
            return;
        }
        this.pollingEnabled = properties.getPropertyAsBoolean(POLLING_ENABLED, false);
        this.pollingIntervalMillis = properties.getPropertyAsLong(POLLING_INTERVAL_MILLIS, -1L);
        long pollingIntervalSeconds = properties.getPropertyAsLong(POLLING_INTERVAL_SECONDS, -1L);
        if (pollingIntervalSeconds > -1L) {
            this.pollingIntervalMillis = pollingIntervalSeconds * 1000L;
        }
        this.piggybackingEnabled = properties.getPropertyAsBoolean("piggybacking-enabled", false);
        this.maxWaitingPollRequests = properties.getPropertyAsInt(MAX_WAITING_POLL_REQUESTS, 0);
        this.waitInterval = properties.getPropertyAsLong(WAIT_INTERVAL_MILLIS, 0L);
        this.clientWaitInterval = properties.getPropertyAsInt(CLIENT_WAIT_INTERVAL_MILLIS, 0);
        UserAgentManager.setupUserAgentManager(properties, this.userAgentManager);
        if (this.maxWaitingPollRequests > 0 && (this.waitInterval == -1L || this.waitInterval > 0L)) {
            this.waitEnabled = true;
            this.canWait = true;
        }
    }

    public int getClientWaitInterval() {
        return this.clientWaitInterval;
    }

    public void setClientWaitInterval(int value) {
        this.clientWaitInterval = value;
    }

    public int getMaxWaitingPollRequests() {
        return this.maxWaitingPollRequests;
    }

    public void setMaxWaitingPollRequests(int maxWaitingPollRequests) {
        this.maxWaitingPollRequests = maxWaitingPollRequests;
        if (maxWaitingPollRequests > 0 && (this.waitInterval == -1L || this.waitInterval > 0L)) {
            this.waitEnabled = true;
            this.canWait = this.waitingPollRequestsCount < maxWaitingPollRequests;
        }
    }

    public long getWaitInterval() {
        return this.waitInterval;
    }

    public void setWaitInterval(long waitInterval) {
        this.waitInterval = waitInterval;
        if (this.maxWaitingPollRequests > 0 && (waitInterval == -1L || waitInterval > 0L)) {
            this.waitEnabled = true;
            this.canWait = this.waitingPollRequestsCount < this.maxWaitingPollRequests;
        }
    }

    public int getWaitingPollRequestsCount() {
        return this.waitingPollRequestsCount;
    }

    @Override
    public ConfigMap describeEndpoint() {
        ConfigMap endpointConfig = super.describeEndpoint();
        boolean createdProperties = false;
        ConfigMap properties = endpointConfig.getPropertyAsMap("properties", null);
        if (properties == null) {
            properties = new ConfigMap();
            createdProperties = true;
        }
        if (this.pollingEnabled) {
            ConfigMap pollingEnabled = new ConfigMap();
            pollingEnabled.addProperty("", "true");
            properties.addProperty(POLLING_ENABLED, pollingEnabled);
        }
        if (this.pollingIntervalMillis > -1L) {
            ConfigMap pollingInterval = new ConfigMap();
            pollingInterval.addProperty("", String.valueOf(this.pollingIntervalMillis));
            properties.addProperty(POLLING_INTERVAL_MILLIS, pollingInterval);
        }
        if (this.piggybackingEnabled) {
            ConfigMap piggybackingEnabled = new ConfigMap();
            piggybackingEnabled.addProperty("", String.valueOf(piggybackingEnabled));
            properties.addProperty("piggybacking-enabled", piggybackingEnabled);
        }
        if (createdProperties && properties.size() > 0) {
            endpointConfig.addProperty("properties", properties);
        }
        return endpointConfig;
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        this.currentWaitedRequests = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        Enumeration keys = this.currentWaitedRequests.keys();
        while (keys.hasMoreElements()) {
            Object notifier;
            Object k = notifier = keys.nextElement();
            synchronized (k) {
                notifier.notifyAll();
            }
        }
        this.currentWaitedRequests = null;
        super.stop();
    }

    @Override
    public void waitStart(Object notifier) {
        this.currentWaitedRequests.put(notifier, Boolean.TRUE);
    }

    @Override
    public void waitEnd(Object notifier) {
        if (this.currentWaitedRequests != null) {
            this.currentWaitedRequests.remove(notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected FlushResult handleFlexClientPoll(FlexClient flexClient, CommandMessage pollCommand) {
        flushResult = null;
        if (this.canWait && !pollCommand.headerExists("DSSuppressPollWait")) {
            session = FlexContext.getFlexSession();
            var6_5 = this.lock;
            synchronized (var6_5) {
                ++this.waitingPollRequestsCount;
                if (this.waitingPollRequestsCount == this.maxWaitingPollRequests) {
                    thisThreadCanWait = true;
                    this.canWait = false;
                } else if (this.waitingPollRequestsCount > this.maxWaitingPollRequests) {
                    thisThreadCanWait = false;
                    --this.waitingPollRequestsCount;
                    this.canWait = false;
                } else {
                    thisThreadCanWait = true;
                }
            }
            if (thisThreadCanWait) {
                userAgentValue = FlexContext.getHttpRequest().getHeader("User-Agent");
                agentSettings = this.userAgentManager.match(userAgentValue);
                var8_9 = session;
                synchronized (var8_9) {
                    if (agentSettings != null) {
                        session.maxConnectionsPerSession = agentSettings.getMaxPersistentConnectionsPerSession();
                    }
                    ++session.streamingConnectionsCount;
                    if (session.maxConnectionsPerSession == -1 || session.streamingConnectionsCount <= session.maxConnectionsPerSession) {
                        thisThreadCanWait = true;
                    } else {
                        thisThreadCanWait = false;
                        --session.streamingConnectionsCount;
                    }
                }
                if (!thisThreadCanWait) {
                    var8_9 = this.lock;
                    synchronized (var8_9) {
                        --this.waitingPollRequestsCount;
                        if (this.waitingPollRequestsCount < this.maxWaitingPollRequests) {
                            this.canWait = true;
                        }
                    }
                    if (Log.isDebug()) {
                        this.log.debug("Max long-polling requests per session limit (" + session.maxConnectionsPerSession + ") has been reached, this poll won't wait.");
                    }
                }
            }
            if (thisThreadCanWait) {
                if (Log.isDebug()) {
                    this.log.debug("Number of waiting threads for endpoint with id '" + this.getId() + "' is " + this.waitingPollRequestsCount + ".");
                }
                try {
                    flushResult = flexClient.pollWithWait(this.getId(), FlexContext.getFlexSession(), this, this.waitInterval);
                    if (flushResult == null) ** GOTO lbl88
                    if (flushResult instanceof PollFlushResult && ((PollFlushResult)flushResult).isAvoidBusyPolling() && flushResult.getNextFlushWaitTimeMillis() < 3000) {
                        flushResult.setNextFlushWaitTimeMillis(3000);
                    }
                    if (this.clientWaitInterval <= 0 || flushResult.getNextFlushWaitTimeMillis() != 0) ** GOTO lbl88
                    flushResult.setNextFlushWaitTimeMillis(this.clientWaitInterval);
                }
                finally {
                    var6_5 = this.lock;
                    synchronized (var6_5) {
                        --this.waitingPollRequestsCount;
                        if (this.waitingPollRequestsCount < this.maxWaitingPollRequests) {
                            this.canWait = true;
                        }
                    }
                    var6_5 = session;
                    synchronized (var6_5) {
                        --session.streamingConnectionsCount;
                    }
                    if (Log.isDebug()) {
                        this.log.debug("Number of waiting threads for endpoint with id '" + this.getId() + "' is " + this.waitingPollRequestsCount + ".");
                    }
                }
            }
        } else if (Log.isDebug() && this.waitEnabled) {
            if (pollCommand.headerExists("DSSuppressPollWait")) {
                this.log.debug("Suppressing poll wait for this request because it is part of a batch of messages to process.");
            } else {
                this.log.debug("Max waiting poll requests limit '" + this.maxWaitingPollRequests + "' has been reached for endpoint '" + this.getId() + "'. FlexClient with id '" + flexClient.getId() + "' will poll with no wait.");
            }
        }
lbl88:
        // 9 sources

        if (flushResult == null) {
            flushResult = super.handleFlexClientPoll(flexClient, pollCommand);
            if (this.waitEnabled && this.pollingIntervalMillis < 3000L) {
                if (flushResult == null) {
                    flushResult = new FlushResult();
                }
                flushResult.setNextFlushWaitTimeMillis(3000);
            }
        }
        return flushResult;
    }
}

