/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.tree.as.ContainerNode;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.tree.as.ILiteralContainerNode;

public class LiteralContainerEmitter
extends JSSubEmitter
implements ISubEmitter<ILiteralContainerNode> {
    public LiteralContainerEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(ILiteralContainerNode node) {
        ContainerNode cnode = node.getContentsNode();
        IContainerNode.ContainerType type = cnode.getContainerType();
        String preFix = null;
        String postFix = null;
        if (type == IContainerNode.ContainerType.BRACES) {
            preFix = ASEmitterTokens.BLOCK_OPEN.getToken();
            postFix = ASEmitterTokens.BLOCK_CLOSE.getToken();
        } else if (type == IContainerNode.ContainerType.BRACKETS) {
            preFix = ASEmitterTokens.SQUARE_OPEN.getToken();
            postFix = ASEmitterTokens.SQUARE_CLOSE.getToken();
        } else if (type != IContainerNode.ContainerType.IMPLICIT && type == IContainerNode.ContainerType.PARENTHESIS) {
            preFix = ASEmitterTokens.PAREN_OPEN.getToken();
            postFix = ASEmitterTokens.PAREN_CLOSE.getToken();
        }
        if (preFix != null) {
            this.startMapping((ISourceLocation)node);
            this.write(preFix);
            this.endMapping((ISourceLocation)node);
        }
        int len = cnode.getChildCount();
        for (int i = 0; i < len; ++i) {
            IASNode child = cnode.getChild(i);
            this.getWalker().walk(child);
            if (i >= len - 1) continue;
            this.startMapping((ISourceLocation)node, (ISourceLocation)child);
            this.writeToken(ASEmitterTokens.COMMA);
            this.endMapping((ISourceLocation)node);
        }
        if (postFix != null) {
            this.startMapping((ISourceLocation)node, node.getEndLine(), node.getEndColumn() - postFix.length());
            this.write(postFix);
            this.endMapping((ISourceLocation)node);
        }
    }
}

