/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swf.tags;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.flex.swf.tags.ICharacterReferrer;
import org.apache.flex.swf.tags.ICharacterTag;

public class CharacterIterableFactory {
    private static final Iterable<ICharacterTag> EMPTY = new Iterable<ICharacterTag>(){

        @Override
        public Iterator<ICharacterTag> iterator() {
            return new Iterator<ICharacterTag>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public ICharacterTag next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
    };

    public static Iterable<ICharacterTag> collect(Iterable<ICharacterTag> i1, Iterable<ICharacterTag> i2) {
        LinkedHashSet<ICharacterTag> merged = new LinkedHashSet<ICharacterTag>();
        for (ICharacterTag character : i1) {
            merged.add(character);
        }
        for (ICharacterTag character : i2) {
            merged.add(character);
        }
        return merged;
    }

    public static Iterable<ICharacterTag> collect(Iterable<ICharacterTag> i1, Iterable<ICharacterTag> i2, Iterable<ICharacterTag> i3) {
        LinkedHashSet<ICharacterTag> merged = new LinkedHashSet<ICharacterTag>();
        for (ICharacterTag character : i1) {
            merged.add(character);
        }
        for (ICharacterTag character : i2) {
            merged.add(character);
        }
        for (ICharacterTag character : i3) {
            merged.add(character);
        }
        return merged;
    }

    public static Iterable<ICharacterTag> collect(Iterable<? extends ICharacterReferrer> referrers) {
        LinkedHashSet<ICharacterTag> merged = new LinkedHashSet<ICharacterTag>();
        for (ICharacterReferrer iCharacterReferrer : referrers) {
            for (ICharacterTag character : iCharacterReferrer.getReferences()) {
                merged.add(character);
            }
        }
        return merged;
    }

    public static Iterable<ICharacterTag> filterAndCollect(Iterable<?> iterable) {
        LinkedHashSet<ICharacterTag> merged = new LinkedHashSet<ICharacterTag>();
        for (Object object : iterable) {
            if (!(object instanceof ICharacterReferrer)) continue;
            for (ICharacterTag character : ((ICharacterReferrer)object).getReferences()) {
                assert (character != null);
                merged.add(character);
            }
        }
        return merged;
    }

    public static Iterable<ICharacterTag> empty() {
        return EMPTY;
    }

    public static Iterable<ICharacterTag> from(final ICharacterTag character) {
        return new Iterable<ICharacterTag>(){

            @Override
            public Iterator<ICharacterTag> iterator() {
                return new Iterator<ICharacterTag>(){
                    private boolean visited = false;

                    @Override
                    public boolean hasNext() {
                        return !this.visited;
                    }

                    @Override
                    public ICharacterTag next() {
                        if (this.visited) {
                            return null;
                        }
                        this.visited = true;
                        return character;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

