/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.tools.ant.BuildException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.flexunit.ant.FlexUnitSocketServer;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.report.Report;
import org.flexunit.ant.report.Suite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexUnitSocketThread
implements Callable<Object> {
    private static final String END_OF_SUCCESS = "status=\"success\" />";
    private static final String END_OF_FAILURE = "</testcase>";
    private static final String END_OF_IGNORE = "<skipped /></testcase>";
    private static final String SUITE_ATTRIBUTE = "classname";
    private File reportDir;
    private FlexUnitSocketServer server;
    private Map<String, Report> reports;

    public FlexUnitSocketThread(FlexUnitSocketServer flexUnitSocketServer, File file, Map<String, Report> map) {
        this.server = flexUnitSocketServer;
        this.reportDir = file;
        this.reports = map;
    }

    @Override
    public Object call() throws Exception {
        try {
            this.server.start();
            this.parseInboundMessages();
        }
        catch (IOException iOException) {
            throw new BuildException("error receiving report from flexunit", (Throwable)iOException);
        }
        finally {
            try {
                this.server.stop();
            }
            catch (IOException iOException) {
                throw new BuildException("could not close client/server socket");
            }
        }
        return null;
    }

    private void parseInboundMessages() throws IOException {
        String string = null;
        while ((string = this.server.readNextTokenFromSocket()) != null) {
            if (string.endsWith(END_OF_FAILURE) || string.endsWith(END_OF_SUCCESS) || string.endsWith(END_OF_IGNORE)) {
                this.processTestReport(string);
                continue;
            }
            throw new BuildException("command [" + string + "] not understood");
        }
    }

    private void processTestReport(String string) {
        Document document = this.parseReport(string);
        String string2 = document.getRootElement().attributeValue(SUITE_ATTRIBUTE);
        if (!this.reports.containsKey(string2 = string2.replaceAll("::", "."))) {
            this.reports.put(string2, new Report(new Suite(string2)));
        }
        Report report = this.reports.get(string2);
        report.addTest(document);
        report.save(this.reportDir);
    }

    private Document parseReport(String string) {
        try {
            Document document = DocumentHelper.parseText(string);
            return document;
        }
        catch (DocumentException documentException) {
            LoggingUtil.log(string);
            throw new BuildException("Error parsing report.", (Throwable)documentException);
        }
    }
}

