/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.launcher.commands.player;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.launcher.commands.player.DefaultPlayerCommand;
import org.flexunit.ant.launcher.commands.player.PlayerCommand;

public class CustomPlayerCommand
implements PlayerCommand {
    private DefaultPlayerCommand proxiedCommand;
    private File executable;

    public PlayerCommand getProxiedCommand() {
        return this.proxiedCommand;
    }

    public void setProxiedCommand(DefaultPlayerCommand defaultPlayerCommand) {
        this.proxiedCommand = defaultPlayerCommand;
    }

    public File getExecutable() {
        return this.executable;
    }

    public void setExecutable(File file) {
        this.executable = file;
    }

    public void setProject(Project project) {
        this.proxiedCommand.setProject(project);
    }

    public void setSwf(File file) {
        this.proxiedCommand.setSwf(file);
    }

    public String getUrl() {
        return this.proxiedCommand.getUrl();
    }

    public void setUrl(String string) {
        this.proxiedCommand.setUrl(string);
    }

    public File getFileToExecute() {
        return this.proxiedCommand.getFileToExecute();
    }

    public void prepare() {
        this.proxiedCommand.prepare();
        this.proxiedCommand.getCommandLine().setExecutable(this.executable.getAbsolutePath());
        this.proxiedCommand.getCommandLine().clearArgs();
        if (this.getUrl() != null) {
            this.proxiedCommand.getCommandLine().addArguments(new String[]{this.getUrl()});
        } else {
            this.proxiedCommand.getCommandLine().addArguments(new String[]{this.getFileToExecute().getAbsolutePath()});
        }
    }

    public Process launch() throws IOException {
        LoggingUtil.log(this.proxiedCommand.getCommandLine().describeCommand());
        return Runtime.getRuntime().exec(this.proxiedCommand.getCommandLine().getCommandline(), this.getJointEnvironment(), this.proxiedCommand.getProject().getBaseDir());
    }

    public void setEnvironment(String[] stringArray) {
        this.proxiedCommand.setEnvironment(stringArray);
    }

    private String[] getJointEnvironment() {
        Vector vector = Execute.getProcEnvironment();
        String[] stringArray = new String[vector.size() + this.proxiedCommand.getEnvironment().length];
        System.arraycopy(vector.toArray(), 0, stringArray, 0, vector.size());
        System.arraycopy(this.proxiedCommand.getEnvironment(), 0, stringArray, vector.size(), this.proxiedCommand.getEnvironment().length);
        return stringArray;
    }
}

