/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.monitoring.MonitoringListener;
import com.amazonaws.services.s3.AmazonS3;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.statistics.StatisticsFromAwsSdk;

@InterfaceAudience.LimitedPrivate(value={"HBoss"})
@InterfaceStability.Evolving
public interface S3ClientFactory {
    public AmazonS3 createS3Client(URI var1, S3ClientCreationParameters var2) throws IOException;

    public static final class S3ClientCreationParameters {
        private AWSCredentialsProvider credentialSet;
        private String endpoint = "";
        private final Map<String, String> headers = new HashMap<String, String>();
        private MonitoringListener monitoringListener;
        private StatisticsFromAwsSdk metrics;
        private boolean pathStyleAccess;
        private boolean requesterPays;
        private List<RequestHandler2> requestHandlers;
        private String userAgentSuffix = "";

        public List<RequestHandler2> getRequestHandlers() {
            return this.requestHandlers;
        }

        public S3ClientCreationParameters withRequestHandlers(@Nullable List<RequestHandler2> handlers) {
            this.requestHandlers = handlers;
            return this;
        }

        public MonitoringListener getMonitoringListener() {
            return this.monitoringListener;
        }

        public S3ClientCreationParameters withMonitoringListener(@Nullable MonitoringListener listener) {
            this.monitoringListener = listener;
            return this;
        }

        public StatisticsFromAwsSdk getMetrics() {
            return this.metrics;
        }

        public S3ClientCreationParameters withMetrics(@Nullable StatisticsFromAwsSdk statistics) {
            this.metrics = statistics;
            return this;
        }

        public S3ClientCreationParameters withRequesterPays(boolean value) {
            this.requesterPays = value;
            return this;
        }

        public boolean isRequesterPays() {
            return this.requesterPays;
        }

        public AWSCredentialsProvider getCredentialSet() {
            return this.credentialSet;
        }

        public S3ClientCreationParameters withCredentialSet(AWSCredentialsProvider value) {
            this.credentialSet = value;
            return this;
        }

        public String getUserAgentSuffix() {
            return this.userAgentSuffix;
        }

        public S3ClientCreationParameters withUserAgentSuffix(String value) {
            this.userAgentSuffix = value;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public S3ClientCreationParameters withEndpoint(String value) {
            this.endpoint = value;
            return this;
        }

        public boolean isPathStyleAccess() {
            return this.pathStyleAccess;
        }

        public S3ClientCreationParameters withPathStyleAccess(boolean value) {
            this.pathStyleAccess = value;
            return this;
        }

        public S3ClientCreationParameters withHeader(String header, String value) {
            this.headers.put(header, value);
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

