/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.windowing;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;

public class SessionWindowing {
    public static void main(String[] args) throws Exception {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        env.setParallelism(1);
        boolean fileOutput = params.has("output");
        final ArrayList<Tuple3> input = new ArrayList<Tuple3>();
        input.add(new Tuple3((Object)"a", (Object)1L, (Object)1));
        input.add(new Tuple3((Object)"b", (Object)1L, (Object)1));
        input.add(new Tuple3((Object)"b", (Object)3L, (Object)1));
        input.add(new Tuple3((Object)"b", (Object)5L, (Object)1));
        input.add(new Tuple3((Object)"c", (Object)6L, (Object)1));
        input.add(new Tuple3((Object)"a", (Object)10L, (Object)1));
        input.add(new Tuple3((Object)"c", (Object)11L, (Object)1));
        DataStreamSource source = env.addSource((SourceFunction)new SourceFunction<Tuple3<String, Long, Integer>>(){
            private static final long serialVersionUID = 1L;

            public void run(SourceFunction.SourceContext<Tuple3<String, Long, Integer>> ctx) throws Exception {
                for (Tuple3 value : input) {
                    ctx.collectWithTimestamp((Object)value, ((Long)value.f1).longValue());
                    ctx.emitWatermark(new Watermark((Long)value.f1 - 1L));
                }
                ctx.emitWatermark(new Watermark(Long.MAX_VALUE));
            }

            public void cancel() {
            }
        });
        SingleOutputStreamOperator aggregated = source.keyBy((KeySelector & Serializable)value -> (String)value.f0).window((WindowAssigner)EventTimeSessionWindows.withGap((Time)Time.milliseconds((long)3L))).sum(2);
        if (fileOutput) {
            aggregated.sinkTo((Sink)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)new Path(params.get("output")), (Encoder)new SimpleStringEncoder()).withRollingPolicy((RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(MemorySize.ofMebiBytes((long)1L)).withRolloverInterval(Duration.ofSeconds(10L)).build())).build()).name("output");
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            aggregated.print();
        }
        env.execute();
    }
}

