/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.CrackAndCluster;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.OperatorSimplifyOGC;
import com.esri.core.geometry.SpatialReference;

public class OGCStructureInternal {
    public static GeometryCursor prepare_for_ops_(GeometryCursor geoms, SpatialReference sr) {
        assert (geoms != null);
        EditShape editShape = new EditShape();
        int geomIndex = editShape.createGeometryUserIndex();
        Geometry g2 = geoms.next();
        while (g2 != null) {
            int egeom = editShape.addGeometry(g2);
            editShape.setGeometryUserIndex(egeom, geomIndex, geoms.getGeometryID());
            g2 = geoms.next();
        }
        Envelope2D env = editShape.getEnvelope2D();
        double tolerance = InternalUtils.calculateToleranceFromGeometry(sr, env, true);
        CrackAndCluster.execute(editShape, tolerance, null, true);
        return OperatorSimplifyOGC.local().execute(new EditShapeCursor(editShape, geomIndex), sr, false, null);
    }

    private static class EditShapeCursor
    extends GeometryCursor {
        EditShape m_shape;
        int m_geom;
        int m_index;

        EditShapeCursor(EditShape shape, int index) {
            this.m_shape = shape;
            this.m_geom = -1;
            this.m_index = index;
        }

        @Override
        public Geometry next() {
            if (this.m_shape != null) {
                this.m_geom = this.m_geom == -1 ? this.m_shape.getFirstGeometry() : this.m_shape.getNextGeometry(this.m_geom);
                if (this.m_geom == -1) {
                    this.m_shape = null;
                } else {
                    return this.m_shape.getGeometry(this.m_geom);
                }
            }
            return null;
        }

        @Override
        public int getGeometryID() {
            return this.m_shape.getGeometryUserIndex(this.m_geom, this.m_index);
        }
    }
}

