/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.hint;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Snapshot;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.hint.HintPredicate;
import org.apache.calcite.rel.hint.RelHint;

public class NodeTypeHintPredicate
implements HintPredicate {
    private NodeType nodeType;

    public NodeTypeHintPredicate(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public boolean apply(RelHint hint, RelNode rel) {
        switch (this.nodeType) {
            case SET_VAR: {
                return false;
            }
        }
        return this.nodeType.relClazz.isInstance(rel);
    }

    static enum NodeType {
        SET_VAR(RelNode.class),
        JOIN(Join.class),
        TABLE_SCAN(TableScan.class),
        FILTER(Filter.class),
        PROJECT(Project.class),
        CORRELATE(Correlate.class),
        AGGREGATE(Aggregate.class),
        CALC(Calc.class),
        SETOP(SetOp.class),
        SORT(Sort.class),
        VALUES(Values.class),
        WINDOW(Window.class),
        SNAPSHOT(Snapshot.class);

        private Class<?> relClazz;

        private NodeType(Class<?> relClazz) {
            this.relClazz = relClazz;
        }
    }
}

