/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.DateTimeStringUtils;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.base.Strings;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class TimeString
implements Comparable<TimeString> {
    private static final Pattern PATTERN = Pattern.compile("[0-9][0-9]:[0-9][0-9]:[0-9][0-9](\\.[0-9]*[1-9])?");
    final String v;

    private TimeString(String v, boolean ignore) {
        this.v = v;
    }

    public TimeString(String v) {
        this(v, false);
        Preconditions.checkArgument(PATTERN.matcher(v).matches(), "Invalid time format:", (Object)v);
        Preconditions.checkArgument(this.getHour() >= 0 && this.getHour() < 24, "Hour out of range:", this.getHour());
        Preconditions.checkArgument(this.getMinute() >= 0 && this.getMinute() < 60, "Minute out of range:", this.getMinute());
        Preconditions.checkArgument(this.getSecond() >= 0 && this.getSecond() < 60, "Second out of range:", this.getSecond());
    }

    public TimeString(int h2, int m3, int s2) {
        this(TimeString.hms(h2, m3, s2), false);
    }

    private static String hms(int h2, int m3, int s2) {
        Preconditions.checkArgument(h2 >= 0 && h2 < 24, "Hour out of range:", h2);
        Preconditions.checkArgument(m3 >= 0 && m3 < 60, "Minute out of range:", m3);
        Preconditions.checkArgument(s2 >= 0 && s2 < 60, "Second out of range:", s2);
        StringBuilder b = new StringBuilder();
        DateTimeStringUtils.hms(b, h2, m3, s2);
        return b.toString();
    }

    public TimeString withMillis(int millis) {
        Preconditions.checkArgument(millis >= 0 && millis < 1000);
        return this.withFraction(DateTimeStringUtils.pad(3, millis));
    }

    public TimeString withNanos(int nanos) {
        Preconditions.checkArgument(nanos >= 0 && nanos < 1000000000);
        return this.withFraction(DateTimeStringUtils.pad(9, nanos));
    }

    public TimeString withFraction(String fraction) {
        String v = this.v;
        int i = v.indexOf(46);
        if (i >= 0) {
            v = v.substring(0, i);
        }
        while (fraction.endsWith("0")) {
            fraction = fraction.substring(0, fraction.length() - 1);
        }
        if (fraction.length() > 0) {
            v = v + "." + fraction;
        }
        return new TimeString(v);
    }

    public String toString() {
        return this.v;
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof TimeString && ((TimeString)o).v.equals(this.v);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public int compareTo(TimeString o) {
        return this.v.compareTo(o.v);
    }

    public static TimeString fromCalendarFields(Calendar calendar) {
        return new TimeString(calendar.get(11), calendar.get(12), calendar.get(13)).withMillis(calendar.get(14));
    }

    public static TimeString fromMillisOfDay(int i) {
        return new TimeString(DateTimeUtils.unixTimeToString(i)).withMillis((int)DateTimeUtils.floorMod(i, 1000L));
    }

    public TimeString round(int precision) {
        Preconditions.checkArgument(precision >= 0);
        int targetLength = 9 + precision;
        if (this.v.length() <= targetLength) {
            return this;
        }
        String v = this.v.substring(0, targetLength);
        while (v.length() >= 9 && (v.endsWith("0") || v.endsWith("."))) {
            v = v.substring(0, v.length() - 1);
        }
        return new TimeString(v);
    }

    public int getMillisOfDay() {
        int h2 = Integer.valueOf(this.v.substring(0, 2));
        int m3 = Integer.valueOf(this.v.substring(3, 5));
        int s2 = Integer.valueOf(this.v.substring(6, 8));
        int ms = this.getMillisInSecond();
        return (int)((long)h2 * 3600000L + (long)m3 * 60000L + (long)s2 * 1000L + (long)ms);
    }

    private int getMillisInSecond() {
        switch (this.v.length()) {
            case 8: {
                return 0;
            }
            case 10: {
                return Integer.valueOf(this.v.substring(9)) * 100;
            }
            case 11: {
                return Integer.valueOf(this.v.substring(9)) * 10;
            }
        }
        return Integer.valueOf(this.v.substring(9, 12));
    }

    private int getHour() {
        return Integer.parseInt(this.v.substring(0, 2));
    }

    private int getMinute() {
        return Integer.parseInt(this.v.substring(3, 5));
    }

    private int getSecond() {
        return Integer.parseInt(this.v.substring(6, 8));
    }

    public Calendar toCalendar() {
        return Util.calendar(this.getMillisOfDay());
    }

    public String toString(int precision) {
        Preconditions.checkArgument(precision >= 0);
        int p = this.precision();
        if (precision < p) {
            return this.round(precision).toString(precision);
        }
        if (precision > p) {
            String s2 = this.v;
            if (p == 0) {
                s2 = s2 + ".";
            }
            return s2 + Strings.repeat("0", precision - p);
        }
        return this.v;
    }

    private int precision() {
        return this.v.length() < 9 ? 0 : this.v.length() - 9;
    }
}

