/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveTable;
import org.apache.flink.sql.parser.hive.impl.ParseException;

public class SqlAlterHiveTableSerDe
extends SqlAlterHiveTable {
    private final SqlCharStringLiteral serdeLib;
    private final SqlNodeList origSerDeProps;

    public SqlAlterHiveTableSerDe(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList partitionSpec, SqlNodeList propertyList, SqlCharStringLiteral serdeLib) throws ParseException {
        super(SqlAlterHiveTable.AlterTableOp.CHANGE_SERDE_PROPS, pos, tableName, partitionSpec, HiveDDLUtils.checkReservedTableProperties(propertyList));
        HiveDDLUtils.unescapeProperties(propertyList);
        this.origSerDeProps = new SqlNodeList(propertyList.getList().subList(0, propertyList.size() - 1), propertyList.getParserPosition());
        SqlAlterHiveTableSerDe.appendPrefix(this.getPropertyList());
        if (serdeLib != null) {
            propertyList.add(HiveDDLUtils.toTableOption("hive.serde.lib.class.name", serdeLib, serdeLib.getParserPosition()));
        }
        this.serdeLib = serdeLib;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("SET");
        if (this.serdeLib != null) {
            writer.keyword("SERDE");
            this.serdeLib.unparse(writer, leftPrec, rightPrec);
        }
        if (this.origSerDeProps != null && this.origSerDeProps.size() > 0) {
            if (this.serdeLib == null) {
                writer.keyword("SERDEPROPERTIES");
            } else {
                writer.keyword("WITH SERDEPROPERTIES");
            }
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.origSerDeProps) {
                SqlUnparseUtils.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    private static SqlNodeList appendPrefix(SqlNodeList propList) {
        if (propList != null) {
            for (int i = 0; i < propList.size(); ++i) {
                SqlTableOption tableOption = (SqlTableOption)propList.get(i);
                if (tableOption.getKeyString().equals("alter.table.op")) continue;
                String key = "hive.serde.info.prop." + tableOption.getKeyString();
                tableOption = HiveDDLUtils.toTableOption(key, tableOption.getValue(), tableOption.getParserPosition());
                propList.set(i, tableOption);
            }
        }
        return propList;
    }
}

