/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.calls;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CollectorCodeGenerator$;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.ExternalGeneratedExpression;
import org.apache.flink.table.planner.codegen.ExternalGeneratedExpression$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.runtime.collector.WrappingCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.operators.join.lookup.DelegatingResultFuture;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class BridgingFunctionGenUtil$ {
    public static BridgingFunctionGenUtil$ MODULE$;

    static {
        new BridgingFunctionGenUtil$();
    }

    public GeneratedExpression generateFunctionAwareCall(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType returnType, TypeInference inference, CallContext callContext, UserDefinedFunction udf, String functionName, boolean skipIfArgsNull) {
        GeneratedExpression call;
        Tuple2<GeneratedExpression, DataType> tuple2 = this.generateFunctionAwareCallWithDataType(ctx, operands, returnType, inference, callContext, udf, functionName, skipIfArgsNull);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        GeneratedExpression generatedExpression = call = (GeneratedExpression)tuple2._1();
        GeneratedExpression call2 = generatedExpression;
        return call2;
    }

    public Tuple2<GeneratedExpression, DataType> generateFunctionAwareCallWithDataType(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType returnType, TypeInference inference, CallContext callContext, UserDefinedFunction udf, String functionName, boolean skipIfArgsNull) {
        CallContext adaptedCallContext = TypeInferenceUtil.adaptArguments((TypeInference)inference, (CallContext)callContext, null);
        Seq enrichedArgumentDataTypes = JavaScalaConversionUtil$.MODULE$.toScala(adaptedCallContext.getArgumentDataTypes());
        this.verifyArgumentTypes((Seq<LogicalType>)((Seq)operands.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.resultType(), Seq$.MODULE$.canBuildFrom())), enrichedArgumentDataTypes);
        DataType enrichedOutputDataType = TypeInferenceUtil.inferOutputType((CallContext)adaptedCallContext, (TypeStrategy)inference.getOutputTypeStrategy());
        this.verifyFunctionAwareOutputType(returnType, enrichedOutputDataType, udf);
        this.verifyFunctionAwareImplementation(enrichedArgumentDataTypes, enrichedOutputDataType, udf, functionName);
        GeneratedExpression call = this.generateFunctionAwareCall(ctx, operands, enrichedArgumentDataTypes, enrichedOutputDataType, returnType, udf, skipIfArgsNull);
        return new Tuple2((Object)call, (Object)enrichedOutputDataType);
    }

    private GeneratedExpression generateFunctionAwareCall(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, Seq<DataType> argumentDataTypes, DataType outputDataType, LogicalType returnType, UserDefinedFunction udf, boolean skipIfArgsNull) {
        GeneratedExpression generatedExpression;
        String functionTerm = ctx.addReusableFunction(udf, ctx.addReusableFunction$default$2(), ctx.addReusableFunction$default$3());
        Seq<GeneratedExpression> externalOperands = this.prepareExternalOperands(ctx, operands, argumentDataTypes);
        FunctionKind functionKind = udf.getKind();
        FunctionKind functionKind2 = FunctionKind.TABLE;
        if (!(functionKind != null ? !functionKind.equals(functionKind2) : functionKind2 != null)) {
            generatedExpression = this.generateTableFunctionCall(ctx, functionTerm, externalOperands, outputDataType, returnType, skipIfArgsNull);
        } else {
            FunctionKind functionKind3 = udf.getKind();
            FunctionKind functionKind4 = FunctionKind.ASYNC_TABLE;
            generatedExpression = !(functionKind3 != null ? !functionKind3.equals(functionKind4) : functionKind4 != null) ? this.generateAsyncTableFunctionCall(functionTerm, externalOperands, returnType) : this.generateScalarFunctionCall(ctx, functionTerm, externalOperands, outputDataType);
        }
        return generatedExpression;
    }

    private GeneratedExpression generateTableFunctionCall(CodeGeneratorContext ctx, String functionTerm, Seq<GeneratedExpression> externalOperands, DataType functionOutputDataType, LogicalType outputType, boolean skipIfArgsNull) {
        String resultCollectorTerm = this.generateResultCollector(ctx, functionOutputDataType, outputType);
        String setCollectorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n                              |").append(functionTerm).append(".setCollector(").append(resultCollectorTerm).append(");\n                              |").toString())).stripMargin();
        ctx.addReusableOpenStatement(setCollectorCode);
        String functionCallCode = skipIfArgsNull ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(112).append("\n         |").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |if (").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.nullTerm(), Seq$.MODULE$.canBuildFrom())).mkString(" || ")).append(") {\n         |  // skip\n         |} else {\n         |  ").append(functionTerm).append(".eval(").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.resultTerm(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n         |}\n         |").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(functionTerm).append(".eval(").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.resultTerm(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n         |").toString())).stripMargin();
        return new GeneratedExpression(resultCollectorTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), functionCallCode, outputType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateAsyncTableFunctionCall(String functionTerm, Seq<GeneratedExpression> externalOperands, LogicalType outputType) {
        String DELEGATE = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(DelegatingResultFuture.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        String functionCallCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n         |").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |if (").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.nullTerm(), Seq$.MODULE$.canBuildFrom())).mkString(" || ")).append(") {\n         |  ").append(CodeGenUtils$.MODULE$.DEFAULT_COLLECTOR_TERM()).append(".complete(java.util.Collections.emptyList());\n         |} else {\n         |  ").append(DELEGATE).append(" delegates = new ").append(DELEGATE).append("(").append(CodeGenUtils$.MODULE$.DEFAULT_COLLECTOR_TERM()).append(");\n         |  ").append(functionTerm).append(".eval(\n         |    delegates.getCompletableFuture(),\n         |    ").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.resultTerm(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n         |}\n         |").toString())).stripMargin();
        return new GeneratedExpression(GeneratedExpression$.MODULE$.NO_CODE(), GeneratedExpression$.MODULE$.NEVER_NULL(), functionCallCode, outputType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private String generateResultCollector(CodeGeneratorContext ctx, DataType outputDataType, LogicalType returnType) {
        String string;
        LogicalType outputType = outputDataType.getLogicalType();
        CodeGeneratorContext collectorCtx = new CodeGeneratorContext(ctx.tableConfig(), ctx.classLoader());
        String externalResultTerm = CodeGenUtils$.MODULE$.newName("externalResult");
        if (!LogicalTypeChecks.isCompositeType((LogicalType)outputType)) {
            ExprCodeGenerator qual$1 = new ExprCodeGenerator(collectorCtx, outputType.isNullable());
            LogicalType x$20 = outputType;
            String x$21 = externalResultTerm;
            Option<int[]> x$22 = qual$1.bindInput$default$3();
            ExprCodeGenerator resultGenerator = qual$1.bindInput(x$20, x$21, x$22);
            GeneratedExpression wrappedResult = resultGenerator.generateConverterResultExpression((RowType)returnType, GenericRowData.class, resultGenerator.generateConverterResultExpression$default$3(), resultGenerator.generateConverterResultExpression$default$4(), resultGenerator.generateConverterResultExpression$default$5(), resultGenerator.generateConverterResultExpression$default$6(), resultGenerator.generateConverterResultExpression$default$7());
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(48).append("\n         |").append(wrappedResult.code()).append("\n         |outputResult(").append(wrappedResult.resultTerm()).append(");\n         |").toString())).stripMargin();
        } else {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(77).append("\n         |if (").append(externalResultTerm).append(" != null) {\n         |  outputResult(").append(externalResultTerm).append(");\n         |}\n         |").toString())).stripMargin();
        }
        String collectorCode = string;
        GeneratedCollector<WrappingCollector<?>> resultCollector = CollectorCodeGenerator$.MODULE$.generateWrappingCollector(collectorCtx, "TableFunctionResultConverterCollector", outputType, externalResultTerm, CodeGenUtils$.MODULE$.genToInternalConverter(ctx, outputDataType), collectorCode);
        String resultCollectorTerm = CodeGenUtils$.MODULE$.newName("resultConverterCollector");
        CollectorCodeGenerator$.MODULE$.addToContext(ctx, resultCollectorTerm, resultCollector);
        return resultCollectorTerm;
    }

    private GeneratedExpression generateScalarFunctionCall(CodeGeneratorContext ctx, String functionTerm, Seq<GeneratedExpression> externalOperands, DataType outputDataType) {
        Class externalResultClass = outputDataType.getConversionClass();
        String externalResultTypeTerm = CodeGenUtils$.MODULE$.typeTerm(externalResultClass);
        Class externalResultClassBoxed = ExtractionUtils.primitiveToWrapper((Class)externalResultClass);
        Class clazz = externalResultClass;
        Class clazz2 = externalResultClassBoxed;
        String externalResultCasting = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? new StringBuilder(2).append("(").append(externalResultTypeTerm).append(")").toString() : new StringBuilder(5).append("(").append(externalResultTypeTerm).append(") (").append(CodeGenUtils$.MODULE$.typeTerm(externalResultClassBoxed)).append(")").toString();
        String externalResultTerm = ctx.addReusableLocalVariable(externalResultTypeTerm, "externalResult");
        String externalCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(58).append("\n         |").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(externalResultTerm).append(" = ").append(externalResultCasting).append(" ").append(functionTerm).append("\n         |  .").append("eval").append("(").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.resultTerm(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n         |").toString())).stripMargin();
        GeneratedExpression internalExpr = CodeGenUtils$.MODULE$.genToInternalConverterAll(ctx, outputDataType, externalResultTerm);
        String x$23 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n                                           |").append(externalCode).append("\n                                           |").append(internalExpr.code()).append("\n                                           |").toString())).stripMargin();
        String x$24 = internalExpr.copy$default$1();
        String x$25 = internalExpr.copy$default$2();
        LogicalType x$26 = internalExpr.copy$default$4();
        Option<Object> x$27 = internalExpr.copy$default$5();
        GeneratedExpression copy = internalExpr.copy(x$24, x$25, x$23, x$26, x$27);
        return ExternalGeneratedExpression$.MODULE$.fromGeneratedExpression(outputDataType, externalResultTerm, externalCode, copy);
    }

    private Seq<GeneratedExpression> prepareExternalOperands(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, Seq<DataType> argumentDataTypes) {
        return (Seq)((TraversableLike)operands.zip(argumentDataTypes, Seq$.MODULE$.canBuildFrom())).map(arg_0 -> BridgingFunctionGenUtil$.$anonfun$prepareExternalOperands$1(ctx, arg_0), Seq$.MODULE$.canBuildFrom());
    }

    private void verifyArgumentTypes(Seq<LogicalType> operandTypes, Seq<DataType> enrichedDataTypes) {
        Seq enrichedTypes = (Seq)enrichedDataTypes.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.getLogicalType(), Seq$.MODULE$.canBuildFrom());
        ((IterableLike)operandTypes.zip((GenIterable)enrichedTypes, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            BridgingFunctionGenUtil$.$anonfun$verifyArgumentTypes$2(x0$2);
            return BoxedUnit.UNIT;
        });
        enrichedDataTypes.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BridgingFunctionGenUtil$.$anonfun$verifyArgumentTypes$3(x$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyFunctionAwareOutputType(LogicalType returnType, DataType enrichedDataType, UserDefinedFunction udf) {
        block6: {
            block5: {
                LogicalType enrichedType = enrichedDataType.getLogicalType();
                FunctionKind functionKind = udf.getKind();
                FunctionKind functionKind2 = FunctionKind.TABLE;
                if (!(functionKind != null ? !functionKind.equals(functionKind2) : functionKind2 != null) && !LogicalTypeChecks.isCompositeType((LogicalType)enrichedType)) {
                    Preconditions.checkState((returnType.is(LogicalTypeRoot.ROW) && returnType.getChildren().size() == 1 ? 1 : 0) != 0, (String)"Logical output type of function call should be a ROW wrapping an atomic type.", (Object[])ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).toArray(ClassTag$.MODULE$.Any())));
                    LogicalType atomicOutputType = (LogicalType)((RowType)returnType).getChildren().get(0);
                    this.verifyOutputType(atomicOutputType, enrichedDataType);
                    return;
                }
                FunctionKind functionKind3 = udf.getKind();
                FunctionKind functionKind4 = FunctionKind.ASYNC_TABLE;
                if (!(functionKind3 != null ? !functionKind3.equals(functionKind4) : functionKind4 != null) && !LogicalTypeChecks.isCompositeType((LogicalType)enrichedType)) {
                    throw new CodeGenException("Async table functions must not emit an atomic type. Only a composite type such as the row type are supported.");
                }
                FunctionKind functionKind5 = udf.getKind();
                FunctionKind functionKind6 = FunctionKind.TABLE;
                if (!(functionKind5 == null ? functionKind6 != null : !functionKind5.equals(functionKind6))) break block5;
                FunctionKind functionKind7 = udf.getKind();
                FunctionKind functionKind8 = FunctionKind.ASYNC_TABLE;
                if (functionKind7 != null ? !functionKind7.equals(functionKind8) : functionKind8 != null) break block6;
            }
            this.verifyOutputType(returnType.copy(true), enrichedDataType);
            return;
        }
        this.verifyOutputType(returnType, enrichedDataType);
    }

    private void verifyOutputType(LogicalType returnType, DataType enrichedDataType) {
        LogicalType enrichedType = enrichedDataType.getLogicalType();
        if (!LogicalTypeCasts.supportsAvoidingCast((LogicalType)enrichedType, (LogicalType)returnType)) {
            throw new CodeGenException(new StringBuilder(56).append("Mismatch of expected output data type '").append(returnType).append("' and function's ").append(new StringBuilder(15).append("output type '").append(enrichedType).append("'.").toString()).toString());
        }
        DataTypeUtils.validateInputDataType((DataType)enrichedDataType);
    }

    public void verifyFunctionAwareImplementation(Seq<DataType> argumentDataTypes, DataType outputDataType, UserDefinedFunction udf, String functionName) {
        FunctionKind functionKind = udf.getKind();
        FunctionKind functionKind2 = FunctionKind.TABLE;
        if (!(functionKind != null ? !functionKind.equals(functionKind2) : functionKind2 != null)) {
            this.verifyImplementation("eval", argumentDataTypes, (Option<DataType>)None$.MODULE$, udf, functionName);
        } else {
            FunctionKind functionKind3 = udf.getKind();
            FunctionKind functionKind4 = FunctionKind.ASYNC_TABLE;
            if (!(functionKind3 != null ? !functionKind3.equals(functionKind4) : functionKind4 != null)) {
                DataType dataType = (DataType)DataTypes.NULL().bridgedTo(CompletableFuture.class);
                this.verifyImplementation("eval", (Seq<DataType>)((Seq)argumentDataTypes.$plus$colon((Object)dataType, Seq$.MODULE$.canBuildFrom())), (Option<DataType>)None$.MODULE$, udf, functionName);
            } else {
                FunctionKind functionKind5 = udf.getKind();
                FunctionKind functionKind6 = FunctionKind.SCALAR;
                if (!(functionKind5 != null ? !functionKind5.equals(functionKind6) : functionKind6 != null)) {
                    this.verifyImplementation("eval", argumentDataTypes, (Option<DataType>)new Some((Object)outputDataType), udf, functionName);
                } else {
                    throw new CodeGenException(new StringBuilder(45).append("Unsupported function kind '").append(udf.getKind()).append("' for function '").append(functionName).append("'.").toString());
                }
            }
        }
    }

    private void verifyImplementation(String methodName, Seq<DataType> argumentDataTypes, Option<DataType> outputDataType, UserDefinedFunction udf, String functionName) {
        Class[] argumentClasses = (Class[])((TraversableOnce)argumentDataTypes.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.getConversionClass(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class));
        Class outputClass = (Class)outputDataType.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getConversionClass()).getOrElse((Function0 & Serializable & scala.Serializable)() -> BoxedUnit.TYPE);
        UserDefinedFunctionHelper.validateClassForRuntime((Class)udf.getClass(), (String)methodName, (Class[])argumentClasses, (Class)outputClass, (String)functionName);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ GeneratedExpression $anonfun$prepareExternalOperands$1(CodeGeneratorContext ctx$1, Tuple2 x0$1) {
        block3: {
            block2: {
                var4_2 = x0$1;
                if (var4_2 == null) break block2;
                operand = (GeneratedExpression)var4_2._1();
                dataType = (DataType)var4_2._2();
                var7_5 = operand;
                if (!(var7_5 instanceof ExternalGeneratedExpression)) ** GOTO lbl-1000
                var8_6 = (ExternalGeneratedExpression)var7_5;
                if (DataTypeUtils.isInternal((DataType)dataType)) ** GOTO lbl-1000
                v0 = var8_6.getDataType();
                var9_7 = dataType;
                if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                    x$28 = var8_6.getExternalTerm();
                    x$29 = var8_6.getExternalCode();
                    x$30 = operand.copy$default$2();
                    x$31 = operand.copy$default$4();
                    x$32 = operand.copy$default$5();
                    var3_13 = operand.copy(x$28, x$30, x$29, x$31, x$32);
                } else lbl-1000:
                // 3 sources

                {
                    var3_13 = operand.copy(CodeGenUtils$.MODULE$.genToExternalConverterAll(ctx$1, dataType, operand), operand.copy$default$2(), operand.copy$default$3(), operand.copy$default$4(), operand.copy$default$5());
                }
                break block3;
            }
            throw new MatchError((Object)var4_2);
        }
        var2_14 = var3_13;
        return var2_14;
    }

    public static final /* synthetic */ void $anonfun$verifyArgumentTypes$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            LogicalType enrichedType;
            LogicalType operandType = (LogicalType)tuple2._1();
            if (!LogicalTypeCasts.supportsAvoidingCast((LogicalType)operandType, (LogicalType)(enrichedType = (LogicalType)tuple2._2()))) {
                throw new CodeGenException(new StringBuilder(56).append("Mismatch of function's argument data type '").append(enrichedType).append("' and actual ").append(new StringBuilder(17).append("argument type '").append(operandType).append("'.").toString()).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$verifyArgumentTypes$3(DataType x$1) {
        DataTypeUtils.validateOutputDataType((DataType)x$1);
    }

    private BridgingFunctionGenUtil$() {
        MODULE$ = this;
    }
}

