/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.ExplainFormat;
import org.apache.flink.table.api.PlanReference;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.InternalPlan;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.delegation.DefaultExecutor;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.processor.DeadlockBreakupProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.DynamicFilteringDependencyProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ForwardHashExchangeProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.MultipleInputNodeCreationProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ResetTransformationProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodePlanDumper;
import org.apache.flink.table.planner.plan.optimize.BatchCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0001\u0003\u0001=\u0011ABQ1uG\"\u0004F.\u00198oKJT!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0017Ac\u0017M\u001c8fe\n\u000b7/\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005AQ\r_3dkR|'\u000f\u0005\u0002\u001835\t\u0001D\u0003\u0002\u0004\r%\u0011!\u0004\u0007\u0002\t\u000bb,7-\u001e;pe\"AA\u0004\u0001B\u0001B\u0003%Q$A\u0006uC\ndWmQ8oM&<\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0007\u0003\r\t\u0007/[\u0005\u0003E}\u00111\u0002V1cY\u0016\u001cuN\u001c4jO\"IA\u0005\u0001B\u0001B\u0003%QeK\u0001\u000e[>$W\u000f\\3NC:\fw-\u001a:\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!2\u0011AB7pIVdW-\u0003\u0002+O\tiQj\u001c3vY\u0016l\u0015M\\1hKJL!\u0001\n\n\t\u00135\u0002!\u0011!Q\u0001\n9\"\u0014a\u00044v]\u000e$\u0018n\u001c8DCR\fGn\\4\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0011aB2bi\u0006dwnZ\u0005\u0003gA\u0012qBR;oGRLwN\\\"bi\u0006dwnZ\u0005\u0003[IA\u0011B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u001e\u0002\u001d\r\fG/\u00197pO6\u000bg.Y4feB\u0011q\u0006O\u0005\u0003sA\u0012abQ1uC2|w-T1oC\u001e,'/\u0003\u00027%!AA\b\u0001B\u0001B\u0003%Q(A\u0006dY\u0006\u001c8\u000fT8bI\u0016\u0014\bC\u0001 D\u001b\u0005y$B\u0001!B\u0003\u0011a\u0017M\\4\u000b\u0003\t\u000bAA[1wC&\u0011Ai\u0010\u0002\f\u00072\f7o\u001d'pC\u0012,'\u000fC\u0003G\u0001\u0011\u0005q)\u0001\u0004=S:LGO\u0010\u000b\b\u0011&S5\nT'O!\t\t\u0002\u0001C\u0003\u0016\u000b\u0002\u0007a\u0003C\u0003\u001d\u000b\u0002\u0007Q\u0004C\u0003%\u000b\u0002\u0007Q\u0005C\u0003.\u000b\u0002\u0007a\u0006C\u00037\u000b\u0002\u0007q\u0007C\u0003=\u000b\u0002\u0007Q\bC\u0003Q\u0001\u0011E\u0013+\u0001\u0007hKR$&/Y5u\t\u001647/F\u0001S!\r\u0019f\u000bW\u0007\u0002)*\tQ+A\u0003tG\u0006d\u0017-\u0003\u0002X)\n)\u0011I\u001d:bsB\u0012\u0011l\u0019\t\u00045~\u000bW\"A.\u000b\u0005qk\u0016\u0001\u00029mC:T!A\u0018\u0006\u0002\u000f\r\fGnY5uK&\u0011\u0001m\u0017\u0002\f%\u0016dGK]1ji\u0012+g\r\u0005\u0002cG2\u0001A!\u00033P\u0003\u0003\u0005\tQ!\u0001f\u0005\ryF%M\t\u0003M&\u0004\"aU4\n\u0005!$&a\u0002(pi\"Lgn\u001a\t\u00035*L!a[.\u0003\u0011I+G\u000e\u0016:bSRDQ!\u001c\u0001\u0005R9\fAbZ3u\u001fB$\u0018.\\5{KJ,\u0012a\u001c\t\u0003aRl\u0011!\u001d\u0006\u0003eN\f\u0001b\u001c9uS6L'0\u001a\u0006\u00039\u0012I!!^9\u0003\u0013=\u0003H/[7ju\u0016\u0014\b\"B<\u0001\t#B\u0018AG4fi\u0016CXm\u0019(pI\u0016<%/\u00199i!J|7-Z:t_J\u001cX#A=\u0011\u000bi\f)!a\u0003\u000f\u0007m\f\tA\u0004\u0002}\u007f6\tQP\u0003\u0002\u007f\u001d\u00051AH]8pizJ\u0011!V\u0005\u0004\u0003\u0007!\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\tIAA\u0002TKFT1!a\u0001U!\u0011\ti!a\u0007\u000e\u0005\u0005=!\u0002BA\t\u0003'\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u000b\t\u0005U\u0011qC\u0001\u0005Kb,7MC\u0002\u0002\u001aM\fQA\\8eKNLA!!\b\u0002\u0010\t1R\t_3d\u001d>$Wm\u0012:ba\"\u0004&o\\2fgN|'\u000fC\u0004\u0002\"\u0001!\t&a\t\u0002\u001fQ\u0014\u0018M\\:mCR,Gk\u001c)mC:$B!!\n\u0002PA1\u0011qEA\u0017\u0003ci!!!\u000b\u000b\u0007\u0005-\u0012)\u0001\u0003vi&d\u0017\u0002BA\u0018\u0003S\u0011A\u0001T5tiB\"\u00111GA\"!\u0019\t)$!\u0010\u0002B5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$A\u0002eC\u001eT!\u0001\t\u0005\n\t\u0005}\u0012q\u0007\u0002\u000f)J\fgn\u001d4pe6\fG/[8o!\r\u0011\u00171\t\u0003\r\u0003\u000b\ny\"!A\u0001\u0002\u000b\u0005\u0011q\t\u0002\u0004?\u0012\u0012\u0014c\u00014\u0002JA\u00191+a\u0013\n\u0007\u00055CKA\u0002B]fD\u0001\"!\u0015\u0002 \u0001\u0007\u00111K\u0001\nKb,7m\u0012:ba\"\u0004B!!\u0016\u0002X5\u0011\u00111C\u0005\u0005\u00033\n\u0019BA\u0007Fq\u0016\u001cgj\u001c3f\u000fJ\f\u0007\u000f\u001b\u0005\b\u0003;\u0002A\u0011IA0\u0003\u001d)\u0007\u0010\u001d7bS:$\u0002\"!\u0019\u0002r\u0005\u0005\u00151\u0012\t\u0005\u0003G\nYG\u0004\u0003\u0002f\u0005\u001d\u0004C\u0001?U\u0013\r\tI\u0007V\u0001\u0007!J,G-\u001a4\n\t\u00055\u0014q\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%D\u000b\u0003\u0005\u0002t\u0005m\u0003\u0019AA;\u0003)y\u0007/\u001a:bi&|gn\u001d\t\u0007\u0003O\ti#a\u001e\u0011\t\u0005e\u0014QP\u0007\u0003\u0003wR1!a\u001d\u0007\u0013\u0011\ty(a\u001f\u0003\u0013=\u0003XM]1uS>t\u0007\u0002CAB\u00037\u0002\r!!\"\u0002\r\u0019|'/\\1u!\rq\u0012qQ\u0005\u0004\u0003\u0013{\"!D#ya2\f\u0017N\u001c$pe6\fG\u000f\u0003\u0005\u0002\u000e\u0006m\u0003\u0019AAH\u00031)\u0007\u0010\u001e:b\t\u0016$\u0018-\u001b7t!\u0015\u0019\u0016\u0011SAK\u0013\r\t\u0019\n\u0016\u0002\u000byI,\u0007/Z1uK\u0012t\u0004c\u0001\u0010\u0002\u0018&\u0019\u0011\u0011T\u0010\u0003\u001b\u0015C\b\u000f\\1j]\u0012+G/Y5m\u0011\u001d\ti\n\u0001C\u0005\u0003?\u000b!c\u0019:fCR,G)^7nsBc\u0017M\u001c8feR\t\u0001\nC\u0004\u0002$\u0002!\t%!*\u0002\u00111|\u0017\r\u001a)mC:$B!a*\u0002.B\u0019q#!+\n\u0007\u0005-\u0006D\u0001\u0007J]R,'O\\1m!2\fg\u000e\u0003\u0005\u00020\u0006\u0005\u0006\u0019AAY\u00035\u0001H.\u00198SK\u001a,'/\u001a8dKB\u0019a$a-\n\u0007\u0005UvDA\u0007QY\u0006t'+\u001a4fe\u0016t7-\u001a\u0005\b\u0003s\u0003A\u0011IA^\u0003-\u0019w.\u001c9jY\u0016\u0004F.\u00198\u0015\t\u0005\u001d\u0016Q\u0018\u0005\t\u0003\u007f\u000b9\f1\u0001\u0002B\u0006\u0001Rn\u001c3jMf|\u0005/\u001a:bi&|gn\u001d\t\u0007\u0003O\ti#a1\u0011\t\u0005e\u0014QY\u0005\u0005\u0003\u000f\fYHA\bN_\u0012Lg-_(qKJ\fG/[8o\u0011\u001d\tY\r\u0001C!\u0003\u001b\fQ\u0002\u001e:b]Nd\u0017\r^3QY\u0006tG\u0003BAh\u00037\u0004b!a\n\u0002.\u0005E\u0007\u0007BAj\u0003/\u0004b!!\u000e\u0002>\u0005U\u0007c\u00012\u0002X\u0012a\u0011\u0011\\Ae\u0003\u0003\u0005\tQ!\u0001\u0002H\t\u0019q\fJ\u001a\t\u000fq\u000bI\r1\u0001\u0002(\"9\u0011q\u001c\u0001\u0005B\u0005\u0005\u0018aC3ya2\f\u0017N\u001c)mC:$b!!\u0019\u0002d\u0006\u0015\bb\u0002/\u0002^\u0002\u0007\u0011q\u0015\u0005\t\u0003\u001b\u000bi\u000e1\u0001\u0002\u0010\"9\u0011\u0011\u001e\u0001\u0005B\u0005-\u0018!\u00052fM>\u0014X\r\u0016:b]Nd\u0017\r^5p]R\u0011\u0011Q\u001e\t\u0004'\u0006=\u0018bAAy)\n!QK\\5u\u0001")
public class BatchPlanner
extends PlannerBase {
    private final TableConfig tableConfig;
    private final ClassLoader classLoader;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), RelCollationTraitDef.INSTANCE});
    }

    @Override
    public Optimizer getOptimizer() {
        return new BatchCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors() {
        Object object;
        ArrayList<ExecNodeGraphProcessor> processors = new ArrayList<ExecNodeGraphProcessor>();
        processors.add(new DeadlockBreakupProcessor());
        Object object2 = Predef$.MODULE$.Boolean2boolean((Boolean)this.getTableConfig().get(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED)) ? BoxesRunTime.boxToBoolean((boolean)processors.add(new MultipleInputNodeCreationProcessor(false))) : BoxedUnit.UNIT;
        processors.add(new ForwardHashExchangeProcessor());
        if (Predef$.MODULE$.Boolean2boolean((Boolean)this.getTableConfig().get(OptimizerConfigOptions.TABLE_OPTIMIZER_DYNAMIC_FILTERING_ENABLED))) {
            processors.add(new DynamicFilteringDependencyProcessor());
            object = BoxesRunTime.boxToBoolean((boolean)processors.add(new ResetTransformationProcessor()));
        } else {
            object = BoxedUnit.UNIT;
        }
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(processors);
    }

    @Override
    public List<Transformation<?>> translateToPlan(ExecNodeGraph execGraph) {
        this.beforeTranslation();
        BatchPlanner planner = this.createDummyPlanner();
        Buffer transformations = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execGraph.getRootNodes()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecNode execNode = x0$1;
            if (!(execNode instanceof BatchExecNode)) {
                throw new TableException("Cannot generate BoundedStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
            }
            BatchExecNode batchExecNode = (BatchExecNode)execNode;
            Transformation transformation = batchExecNode.translateToPlan(planner);
            return transformation;
        }, Buffer$.MODULE$.canBuildFrom());
        this.afterTranslation();
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(transformations.$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(planner.extraTransformations())));
    }

    public String explain(List<Operation> operations, ExplainFormat format, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        ExplainFormat explainFormat = format;
        ExplainFormat explainFormat2 = ExplainFormat.TEXT;
        if (explainFormat == null ? explainFormat2 != null : !explainFormat.equals(explainFormat2)) {
            throw new UnsupportedOperationException(new java.lang.StringBuilder(29).append("Unsupported explain format [").append(format.getClass().getCanonicalName()).append("]").toString());
        }
        if (extraDetails.contains((Object)ExplainDetail.PLAN_ADVICE)) {
            throw new UnsupportedOperationException("EXPLAIN PLAN_ADVICE is not supported under batch mode.");
        }
        Tuple4<Buffer<RelNode>, Seq<RelNode>, ExecNodeGraph, StreamGraph> tuple4 = this.getExplainGraphs(operations);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Buffer sinkRelNodes = (Buffer)tuple4._1();
        Seq optimizedRelNodes = (Seq)tuple4._2();
        ExecNodeGraph execGraph = (ExecNodeGraph)tuple4._3();
        StreamGraph streamGraph = (StreamGraph)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)sinkRelNodes, (Object)optimizedRelNodes, (Object)execGraph, (Object)streamGraph);
        Tuple4 tuple43 = tuple42;
        Buffer sinkRelNodes2 = (Buffer)tuple43._1();
        Seq optimizedRelNodes2 = (Seq)tuple43._2();
        ExecNodeGraph execGraph2 = (ExecNodeGraph)tuple43._3();
        StreamGraph streamGraph2 = (StreamGraph)tuple43._4();
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes2.foreach((Function1 & Serializable & scala.Serializable)sink -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)sink, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Physical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST) ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        optimizedRelNodes2.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)rel, explainLevel, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph2));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph2.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    private BatchPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        DefaultExecutor executor = new DefaultExecutor(dummyExecEnv);
        return new BatchPlanner(executor, this.tableConfig, super.moduleManager(), super.functionCatalog(), super.catalogManager(), this.classLoader);
    }

    public InternalPlan loadPlan(PlanReference planReference) {
        throw new UnsupportedOperationException("The compiled plan feature is not supported in batch mode.");
    }

    public InternalPlan compilePlan(List<ModifyOperation> modifyOperations) {
        throw new UnsupportedOperationException("The compiled plan feature is not supported in batch mode.");
    }

    public List<Transformation<?>> translatePlan(InternalPlan plan) {
        throw new UnsupportedOperationException("The compiled plan feature is not supported in batch mode.");
    }

    public String explainPlan(InternalPlan plan, Seq<ExplainDetail> extraDetails) {
        throw new UnsupportedOperationException("The compiled plan feature is not supported in batch mode.");
    }

    @Override
    public void beforeTranslation() {
        RuntimeExecutionMode runtimeMode;
        super.beforeTranslation();
        RuntimeExecutionMode runtimeExecutionMode = runtimeMode = (RuntimeExecutionMode)this.getTableConfig().get(ExecutionOptions.RUNTIME_MODE);
        RuntimeExecutionMode runtimeExecutionMode2 = RuntimeExecutionMode.BATCH;
        if (runtimeExecutionMode == null ? runtimeExecutionMode2 != null : !runtimeExecutionMode.equals(runtimeExecutionMode2)) {
            throw new IllegalArgumentException("Mismatch between configured runtime mode and actual runtime mode. Currently, the 'execution.runtime-mode' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        }
    }

    public String explainPlan(InternalPlan plan, ExplainDetail[] extraDetails) {
        return this.explainPlan(plan, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public String explain(List<Operation> operations, ExplainFormat format, ExplainDetail[] extraDetails) {
        return this.explain(operations, format, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public BatchPlanner(Executor executor, TableConfig tableConfig, ModuleManager moduleManager, FunctionCatalog functionCatalog, CatalogManager catalogManager, ClassLoader classLoader) {
        this.tableConfig = tableConfig;
        this.classLoader = classLoader;
        super(executor, tableConfig, moduleManager, functionCatalog, catalogManager, false, classLoader);
    }
}

