/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;

@Internal
public class DirectConvertRule
implements CallExpressionConvertRule {
    private static Map<Boolean, DirectConvertRule> cachedInstances = new HashMap<Boolean, DirectConvertRule>();
    private final Map<FunctionDefinition, SqlOperator> definitionSqlOperatorHashMap = new HashMap<FunctionDefinition, SqlOperator>();

    public static synchronized DirectConvertRule instance(boolean isBatchMode) {
        DirectConvertRule instance = cachedInstances.get(isBatchMode);
        if (instance == null) {
            instance = new DirectConvertRule();
            instance.initNonDynamicFunctions();
            instance.initDynamicFunctions(isBatchMode);
            cachedInstances.put(isBatchMode, instance);
        }
        return instance;
    }

    void initDynamicFunctions(boolean isBatchMode) {
        FlinkSqlOperatorTable.dynamicFunctions(isBatchMode).forEach(func -> {
            if (func.getName().equalsIgnoreCase(SqlStdOperatorTable.CURRENT_DATE.getName())) {
                this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_DATE, (SqlOperator)func);
            } else if (func.getName().equalsIgnoreCase(SqlStdOperatorTable.CURRENT_TIME.getName())) {
                this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_TIME, (SqlOperator)func);
            } else if (func.getName().equalsIgnoreCase(SqlStdOperatorTable.LOCALTIME.getName())) {
                this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LOCAL_TIME, (SqlOperator)func);
            } else if (func.getName().equalsIgnoreCase(SqlStdOperatorTable.CURRENT_TIMESTAMP.getName())) {
                this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_TIMESTAMP, (SqlOperator)func);
            } else if (func.getName().equalsIgnoreCase(SqlStdOperatorTable.LOCALTIMESTAMP.getName())) {
                this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LOCAL_TIMESTAMP, (SqlOperator)func);
            } else if (func.getName().equalsIgnoreCase("NOW")) {
                this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.NOW, (SqlOperator)func);
            } else {
                throw new TableException(String.format("Unsupported mapping for dynamic function: %s", func.getName()));
            }
        });
    }

    void initNonDynamicFunctions() {
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.AND, FlinkSqlOperatorTable.AND);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.OR, FlinkSqlOperatorTable.OR);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.NOT, FlinkSqlOperatorTable.NOT);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.IF, FlinkSqlOperatorTable.CASE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, FlinkSqlOperatorTable.EQUALS);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, FlinkSqlOperatorTable.GREATER_THAN);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, FlinkSqlOperatorTable.LESS_THAN);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.NOT_EQUALS, FlinkSqlOperatorTable.NOT_EQUALS);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_NULL, FlinkSqlOperatorTable.IS_NULL);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_NULL, FlinkSqlOperatorTable.IS_NOT_NULL);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_TRUE, FlinkSqlOperatorTable.IS_TRUE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_FALSE, FlinkSqlOperatorTable.IS_FALSE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_TRUE, FlinkSqlOperatorTable.IS_NOT_TRUE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_FALSE, FlinkSqlOperatorTable.IS_NOT_FALSE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CHAR_LENGTH, FlinkSqlOperatorTable.CHAR_LENGTH);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.INIT_CAP, FlinkSqlOperatorTable.INITCAP);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, FlinkSqlOperatorTable.LIKE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LOWER, FlinkSqlOperatorTable.LOWER);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LOWERCASE, FlinkSqlOperatorTable.LOWER);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SIMILAR, FlinkSqlOperatorTable.SIMILAR_TO);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SUBSTRING, FlinkSqlOperatorTable.SUBSTRING);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SUBSTR, FlinkSqlOperatorTable.SUBSTR);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.UPPER, FlinkSqlOperatorTable.UPPER);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.UPPERCASE, FlinkSqlOperatorTable.UPPER);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.POSITION, FlinkSqlOperatorTable.POSITION);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.OVERLAY, FlinkSqlOperatorTable.OVERLAY);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CONCAT, FlinkSqlOperatorTable.CONCAT_FUNCTION);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CONCAT_WS, FlinkSqlOperatorTable.CONCAT_WS);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LPAD, FlinkSqlOperatorTable.LPAD);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.RPAD, FlinkSqlOperatorTable.RPAD);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.REGEXP_EXTRACT, FlinkSqlOperatorTable.REGEXP_EXTRACT);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.FROM_BASE64, FlinkSqlOperatorTable.FROM_BASE64);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.TO_BASE64, FlinkSqlOperatorTable.TO_BASE64);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.ASCII, FlinkSqlOperatorTable.ASCII);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CHR, FlinkSqlOperatorTable.CHR);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.DECODE, FlinkSqlOperatorTable.DECODE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.ENCODE, FlinkSqlOperatorTable.ENCODE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LEFT, FlinkSqlOperatorTable.LEFT);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.RIGHT, FlinkSqlOperatorTable.RIGHT);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.INSTR, FlinkSqlOperatorTable.INSTR);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LOCATE, FlinkSqlOperatorTable.LOCATE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.PARSE_URL, FlinkSqlOperatorTable.PARSE_URL);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.UUID, FlinkSqlOperatorTable.UUID);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LTRIM, FlinkSqlOperatorTable.LTRIM);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.RTRIM, FlinkSqlOperatorTable.RTRIM);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.REPEAT, FlinkSqlOperatorTable.REPEAT);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.REGEXP, FlinkSqlOperatorTable.REGEXP);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.REGEXP_REPLACE, FlinkSqlOperatorTable.REGEXP_REPLACE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.REVERSE, FlinkSqlOperatorTable.REVERSE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SPLIT_INDEX, FlinkSqlOperatorTable.SPLIT_INDEX);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.STR_TO_MAP, FlinkSqlOperatorTable.STR_TO_MAP);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.MINUS, FlinkSqlOperatorTable.MINUS);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.DIVIDE, FlinkSqlOperatorTable.DIVIDE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.TIMES, FlinkSqlOperatorTable.MULTIPLY);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.FLOOR, FlinkSqlOperatorTable.FLOOR);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CEIL, FlinkSqlOperatorTable.CEIL);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.ABS, FlinkSqlOperatorTable.ABS);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.EXP, FlinkSqlOperatorTable.EXP);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LOG10, FlinkSqlOperatorTable.LOG10);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LOG2, FlinkSqlOperatorTable.LOG2);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LN, FlinkSqlOperatorTable.LN);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.LOG, FlinkSqlOperatorTable.LOG);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.POWER, FlinkSqlOperatorTable.POWER);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.MOD, FlinkSqlOperatorTable.MOD);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.MINUS_PREFIX, FlinkSqlOperatorTable.UNARY_MINUS);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SIN, FlinkSqlOperatorTable.SIN);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.COS, FlinkSqlOperatorTable.COS);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SINH, FlinkSqlOperatorTable.SINH);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.TAN, FlinkSqlOperatorTable.TAN);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.TANH, FlinkSqlOperatorTable.TANH);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.COT, FlinkSqlOperatorTable.COT);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.ASIN, FlinkSqlOperatorTable.ASIN);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.ACOS, FlinkSqlOperatorTable.ACOS);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.ATAN, FlinkSqlOperatorTable.ATAN);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.ATAN2, FlinkSqlOperatorTable.ATAN2);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.COSH, FlinkSqlOperatorTable.COSH);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.DEGREES, FlinkSqlOperatorTable.DEGREES);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.RADIANS, FlinkSqlOperatorTable.RADIANS);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SIGN, FlinkSqlOperatorTable.SIGN);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.ROUND, FlinkSqlOperatorTable.ROUND);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.PI, FlinkSqlOperatorTable.PI);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.E, FlinkSqlOperatorTable.E);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.RAND, FlinkSqlOperatorTable.RAND);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.RAND_INTEGER, FlinkSqlOperatorTable.RAND_INTEGER);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.BIN, FlinkSqlOperatorTable.BIN);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.HEX, FlinkSqlOperatorTable.HEX);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.TRUNCATE, FlinkSqlOperatorTable.TRUNCATE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.EXTRACT, FlinkSqlOperatorTable.EXTRACT);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_ROW_TIMESTAMP, FlinkSqlOperatorTable.CURRENT_ROW_TIMESTAMP);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.DATE_FORMAT, FlinkSqlOperatorTable.DATE_FORMAT);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CONVERT_TZ, FlinkSqlOperatorTable.CONVERT_TZ);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.FROM_UNIXTIME, FlinkSqlOperatorTable.FROM_UNIXTIME);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.UNIX_TIMESTAMP, FlinkSqlOperatorTable.UNIX_TIMESTAMP);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.TO_DATE, FlinkSqlOperatorTable.TO_DATE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.TO_TIMESTAMP_LTZ, FlinkSqlOperatorTable.TO_TIMESTAMP_LTZ);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.TO_TIMESTAMP, FlinkSqlOperatorTable.TO_TIMESTAMP);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_DATABASE, FlinkSqlOperatorTable.CURRENT_DATABASE);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.AT, FlinkSqlOperatorTable.ITEM);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.CARDINALITY, FlinkSqlOperatorTable.CARDINALITY);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.ORDER_DESC, FlinkSqlOperatorTable.DESC);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.ARRAY_ELEMENT, FlinkSqlOperatorTable.ELEMENT);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.MD5, FlinkSqlOperatorTable.MD5);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA2, FlinkSqlOperatorTable.SHA2);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA224, FlinkSqlOperatorTable.SHA224);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA256, FlinkSqlOperatorTable.SHA256);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA384, FlinkSqlOperatorTable.SHA384);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA512, FlinkSqlOperatorTable.SHA512);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.SHA1, FlinkSqlOperatorTable.SHA1);
        this.definitionSqlOperatorHashMap.put((FunctionDefinition)BuiltInFunctionDefinitions.STREAM_RECORD_TIMESTAMP, FlinkSqlOperatorTable.STREAMRECORD_TIMESTAMP);
    }

    @Override
    public Optional<RexNode> convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        SqlOperator operator = this.definitionSqlOperatorHashMap.get(call.getFunctionDefinition());
        return Optional.ofNullable(operator).map(op -> context.getRelBuilder().call((SqlOperator)op, (Iterable<? extends RexNode>)ExpressionConverter.toRexNodes(context, call.getChildren())));
    }
}

