/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.MultipleInputTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.AbstractExecNodeExactlyOnceVisitor;
import org.apache.flink.table.runtime.operators.multipleinput.BatchMultipleInputStreamOperatorFactory;
import org.apache.flink.table.runtime.operators.multipleinput.TableOperatorWrapperGenerator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

public class BatchExecMultipleInput
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private final ExecNode<?> rootNode;
    private final List<ExecEdge> originalEdges;

    public BatchExecMultipleInput(ReadableConfig tableConfig, List<InputProperty> inputProperties, ExecNode<?> rootNode, List<ExecEdge> originalEdges, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecMultipleInput.class), ExecNodeContext.newPersistedConfig(BatchExecMultipleInput.class, tableConfig), inputProperties, rootNode.getOutputType(), description);
        this.rootNode = rootNode;
        Preconditions.checkArgument((inputProperties.size() == originalEdges.size() ? 1 : 0) != 0);
        this.originalEdges = originalEdges;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ArrayList inputTransforms = new ArrayList();
        for (ExecEdge inputEdge : this.getInputEdges()) {
            inputTransforms.add(inputEdge.translateToPlan(planner));
        }
        Transformation outputTransform = this.rootNode.translateToPlan(planner);
        int[] readOrders = this.getInputProperties().stream().map(InputProperty::getPriority).mapToInt(i -> i).toArray();
        TableOperatorWrapperGenerator generator = new TableOperatorWrapperGenerator(inputTransforms, outputTransform, readOrders);
        generator.generate();
        List inputTransformAndInputSpecPairs = generator.getInputTransformAndInputSpecPairs();
        MultipleInputTransformation multipleInputTransform = new MultipleInputTransformation(this.createTransformationName(config), (StreamOperatorFactory)new BatchMultipleInputStreamOperatorFactory(inputTransformAndInputSpecPairs.stream().map(Pair::getValue).collect(Collectors.toList()), generator.getHeadWrappers(), generator.getTailWrapper()), (TypeInformation)InternalTypeInfo.of((LogicalType)this.getOutputType()), generator.getParallelism(), false);
        multipleInputTransform.setDescription(this.createTransformationDescription(config));
        inputTransformAndInputSpecPairs.forEach(input -> multipleInputTransform.addInput((Transformation)input.getKey()));
        if (generator.getMaxParallelism() > 0) {
            multipleInputTransform.setMaxParallelism(generator.getMaxParallelism());
        }
        multipleInputTransform.setResources(generator.getMinResources(), generator.getPreferredResources());
        int memoryWeight = generator.getManagedMemoryWeight();
        long memoryBytes = (long)memoryWeight << 20;
        ExecNodeUtil.setManagedMemoryWeight(multipleInputTransform, memoryBytes);
        multipleInputTransform.setChainingStrategy(ChainingStrategy.HEAD_WITH_SOURCES);
        return multipleInputTransform;
    }

    @Override
    public void resetTransformation() {
        super.resetTransformation();
        AbstractExecNodeExactlyOnceVisitor visitor = new AbstractExecNodeExactlyOnceVisitor(){

            @Override
            protected void visitNode(ExecNode<?> node) {
                ((ExecNodeBase)node).resetTransformation();
                this.visitInputs(node);
            }
        };
        this.rootNode.accept(visitor);
    }

    public List<ExecEdge> getOriginalEdges() {
        return this.originalEdges;
    }

    @VisibleForTesting
    public ExecNode<?> getRootNode() {
        return this.rootNode;
    }
}

