/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.iteration;

import java.time.Duration;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineInputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.IterativeStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;

public class IterateExample {
    private static final int BOUND = 100;
    private static final OutputTag<Tuple5<Integer, Integer, Integer, Integer, Integer>> ITERATE_TAG = new OutputTag<Tuple5<Integer, Integer, Integer, Integer, Integer>>("iterate"){};

    public static void main(String[] args) throws Exception {
        DataStreamSource inputStream;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment().setBufferTimeout(1L);
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        if (params.has("input")) {
            FileSource fileSource = FileSource.forRecordStreamFormat((StreamFormat)new TextLineInputFormat(), (Path[])new Path[]{new Path(params.get("input"))}).build();
            inputStream = env.fromSource((Source)fileSource, WatermarkStrategy.noWatermarks(), "Tuples Source").map((MapFunction)new FibonacciInputMap());
        } else {
            System.out.println("Executing Iterate example with default input data set.");
            System.out.println("Use --input to specify file input.");
            inputStream = env.addSource((SourceFunction)new RandomFibonacciSource());
        }
        IterativeStream it = inputStream.map((MapFunction)new InputMap()).iterate(5000L);
        SingleOutputStreamOperator step = it.process((ProcessFunction)new Step());
        it.closeWith((DataStream)step.getSideOutput(ITERATE_TAG));
        SingleOutputStreamOperator numbers = step.map((MapFunction)new OutputMap());
        if (params.has("output")) {
            numbers.sinkTo((Sink)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)new Path(params.get("output")), (Encoder)new SimpleStringEncoder()).withRollingPolicy((RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(MemorySize.ofMebiBytes((long)1L)).withRolloverInterval(Duration.ofSeconds(10L)).build())).build());
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            numbers.print();
        }
        env.execute("Streaming Iteration Example");
    }

    public static class OutputMap
    implements MapFunction<Tuple5<Integer, Integer, Integer, Integer, Integer>, Tuple2<Tuple2<Integer, Integer>, Integer>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<Tuple2<Integer, Integer>, Integer> map(Tuple5<Integer, Integer, Integer, Integer, Integer> value) throws Exception {
            return new Tuple2((Object)new Tuple2(value.f0, value.f1), value.f4);
        }
    }

    public static class Step
    extends ProcessFunction<Tuple5<Integer, Integer, Integer, Integer, Integer>, Tuple5<Integer, Integer, Integer, Integer, Integer>> {
        private static final long serialVersionUID = 1L;

        public void processElement(Tuple5<Integer, Integer, Integer, Integer, Integer> value, ProcessFunction.Context ctx, Collector<Tuple5<Integer, Integer, Integer, Integer, Integer>> out) throws Exception {
            Tuple5<Integer, Integer, Integer, Integer, Integer> tuple5 = value;
            tuple5.f4 = (Integer)tuple5.f4 + 1;
            Tuple5 element = new Tuple5(value.f0, value.f1, value.f3, (Object)((Integer)value.f2 + (Integer)value.f3), tuple5.f4);
            if ((Integer)value.f2 < 100 && (Integer)value.f3 < 100) {
                ctx.output(ITERATE_TAG, (Object)element);
            } else {
                out.collect((Object)element);
            }
        }
    }

    public static class InputMap
    implements MapFunction<Tuple2<Integer, Integer>, Tuple5<Integer, Integer, Integer, Integer, Integer>> {
        private static final long serialVersionUID = 1L;

        public Tuple5<Integer, Integer, Integer, Integer, Integer> map(Tuple2<Integer, Integer> value) throws Exception {
            return new Tuple5(value.f0, value.f1, value.f0, value.f1, (Object)0);
        }
    }

    private static class FibonacciInputMap
    implements MapFunction<String, Tuple2<Integer, Integer>> {
        private static final long serialVersionUID = 1L;

        private FibonacciInputMap() {
        }

        public Tuple2<Integer, Integer> map(String value) throws Exception {
            String record = value.substring(1, value.length() - 1);
            String[] splitted = record.split(",");
            return new Tuple2((Object)Integer.parseInt(splitted[0]), (Object)Integer.parseInt(splitted[1]));
        }
    }

    private static class RandomFibonacciSource
    implements SourceFunction<Tuple2<Integer, Integer>> {
        private static final long serialVersionUID = 1L;
        private Random rnd = new Random();
        private volatile boolean isRunning = true;
        private int counter = 0;

        private RandomFibonacciSource() {
        }

        public void run(SourceFunction.SourceContext<Tuple2<Integer, Integer>> ctx) throws Exception {
            while (this.isRunning && this.counter < 100) {
                int first = this.rnd.nextInt(49) + 1;
                int second = this.rnd.nextInt(49) + 1;
                ctx.collect((Object)new Tuple2((Object)first, (Object)second));
                ++this.counter;
                Thread.sleep(50L);
            }
        }

        public void cancel() {
            this.isRunning = false;
        }
    }
}

