/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.results;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.gateway.api.operation.OperationStatus;
import org.apache.flink.util.ExceptionUtils;

@PublicEvolving
public class OperationInfo {
    private final OperationStatus status;
    @Nullable
    private final Exception exception;

    public OperationInfo(OperationStatus status) {
        this(status, null);
    }

    public OperationInfo(OperationStatus status, @Nullable Exception exception) {
        this.status = status;
        this.exception = exception;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperationInfo)) {
            return false;
        }
        OperationInfo that = (OperationInfo)o;
        return this.status == that.status && Objects.equals(this.exception, that.exception);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.exception});
    }

    public String toString() {
        return "OperationInfo{status=" + (Object)((Object)this.status) + ", exception=" + (this.exception == null ? "null" : ExceptionUtils.stringifyException((Throwable)this.exception)) + '}';
    }
}

