/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.src.AbstractFileSource;
import org.apache.flink.connector.file.src.ContinuousEnumerationSettings;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.FileSourceSplitSerializer;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.connector.file.src.assigners.LocalityAwareSplitAssigner;
import org.apache.flink.connector.file.src.enumerate.BlockSplittingRecursiveEnumerator;
import org.apache.flink.connector.file.src.enumerate.FileEnumerator;
import org.apache.flink.connector.file.src.enumerate.NonSplittingRecursiveEnumerator;
import org.apache.flink.connector.file.src.impl.FileRecordFormatAdapter;
import org.apache.flink.connector.file.src.impl.StreamFormatAdapter;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.reader.FileRecordFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class FileSource<T>
extends AbstractFileSource<T, FileSourceSplit> {
    private static final long serialVersionUID = 1L;
    public static final FileSplitAssigner.Provider DEFAULT_SPLIT_ASSIGNER = LocalityAwareSplitAssigner::new;
    public static final FileEnumerator.Provider DEFAULT_SPLITTABLE_FILE_ENUMERATOR = BlockSplittingRecursiveEnumerator::new;
    public static final FileEnumerator.Provider DEFAULT_NON_SPLITTABLE_FILE_ENUMERATOR = NonSplittingRecursiveEnumerator::new;

    private FileSource(Path[] inputPaths, FileEnumerator.Provider fileEnumerator, FileSplitAssigner.Provider splitAssigner, BulkFormat<T, FileSourceSplit> readerFormat, @Nullable ContinuousEnumerationSettings continuousEnumerationSettings) {
        super(inputPaths, fileEnumerator, splitAssigner, readerFormat, continuousEnumerationSettings);
    }

    @Override
    public SimpleVersionedSerializer<FileSourceSplit> getSplitSerializer() {
        return FileSourceSplitSerializer.INSTANCE;
    }

    public static <T> FileSourceBuilder<T> forRecordStreamFormat(StreamFormat<T> streamFormat, Path ... paths) {
        return FileSource.forBulkFileFormat(new StreamFormatAdapter<T>(streamFormat), paths);
    }

    public static <T> FileSourceBuilder<T> forBulkFileFormat(BulkFormat<T, FileSourceSplit> bulkFormat, Path ... paths) {
        Preconditions.checkNotNull(bulkFormat, (String)"reader");
        Preconditions.checkNotNull((Object)paths, (String)"paths");
        Preconditions.checkArgument((paths.length > 0 ? 1 : 0) != 0, (Object)"paths must not be empty");
        return new FileSourceBuilder<T>(paths, bulkFormat);
    }

    @Deprecated
    public static <T> FileSourceBuilder<T> forRecordFileFormat(FileRecordFormat<T> recordFormat, Path ... paths) {
        return FileSource.forBulkFileFormat(new FileRecordFormatAdapter<T>(recordFormat), paths);
    }

    public static final class FileSourceBuilder<T>
    extends AbstractFileSource.AbstractFileSourceBuilder<T, FileSourceSplit, FileSourceBuilder<T>> {
        FileSourceBuilder(Path[] inputPaths, BulkFormat<T, FileSourceSplit> readerFormat) {
            super(inputPaths, readerFormat, readerFormat.isSplittable() ? DEFAULT_SPLITTABLE_FILE_ENUMERATOR : DEFAULT_NON_SPLITTABLE_FILE_ENUMERATOR, DEFAULT_SPLIT_ASSIGNER);
        }

        public FileSource<T> build() {
            return new FileSource(this.inputPaths, this.fileEnumerator, this.splitAssigner, this.readerFormat, this.continuousSourceSettings);
        }
    }
}

