/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.processors;

import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerWindowStateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.WindowBuffer;
import org.apache.flink.table.runtime.operators.window.slicing.ClockService;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SlicingWindowProcessor;
import org.apache.flink.table.runtime.operators.window.slicing.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.slicing.WindowTimerServiceImpl;
import org.apache.flink.table.runtime.operators.window.state.WindowValueState;
import org.apache.flink.table.runtime.util.TimeWindowUtil;

public abstract class AbstractWindowAggProcessor
implements SlicingWindowProcessor<Long> {
    private static final long serialVersionUID = 1L;
    protected final GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler;
    protected final WindowBuffer.Factory windowBufferFactory;
    protected final SliceAssigner sliceAssigner;
    protected final TypeSerializer<RowData> accSerializer;
    protected final boolean isEventTime;
    protected final long windowInterval;
    protected final ZoneId shiftTimeZone;
    protected final boolean useDayLightSaving;
    protected transient long currentProgress;
    private transient long nextTriggerProgress;
    protected transient SlicingWindowProcessor.Context<Long> ctx;
    protected transient ClockService clockService;
    protected transient WindowTimerService<Long> windowTimerService;
    protected transient NamespaceAggsHandleFunction<Long> aggregator;
    protected transient WindowBuffer windowBuffer;
    protected transient WindowValueState<Long> windowState;
    protected transient JoinedRowData reuseOutput;

    public AbstractWindowAggProcessor(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler, WindowBuffer.Factory bufferFactory, SliceAssigner sliceAssigner, TypeSerializer<RowData> accSerializer, ZoneId shiftTimeZone) {
        this.genAggsHandler = genAggsHandler;
        this.windowBufferFactory = bufferFactory;
        this.sliceAssigner = sliceAssigner;
        this.accSerializer = accSerializer;
        this.isEventTime = sliceAssigner.isEventTime();
        this.windowInterval = sliceAssigner.getSliceEndInterval();
        this.shiftTimeZone = shiftTimeZone;
        this.useDayLightSaving = TimeZone.getTimeZone(shiftTimeZone).useDaylightTime();
    }

    @Override
    public void open(SlicingWindowProcessor.Context<Long> context) throws Exception {
        this.ctx = context;
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        ValueState state = (ValueState)this.ctx.getKeyedStateBackend().getOrCreateKeyedState((TypeSerializer)namespaceSerializer, (StateDescriptor)new ValueStateDescriptor("window-aggs", this.accSerializer));
        this.windowState = new WindowValueState((InternalValueState)state);
        this.clockService = ClockService.of(this.ctx.getTimerService());
        this.windowTimerService = new WindowTimerServiceImpl(this.ctx.getTimerService(), this.shiftTimeZone);
        this.aggregator = (NamespaceAggsHandleFunction)this.genAggsHandler.newInstance(this.ctx.getRuntimeContext().getUserCodeClassLoader());
        this.aggregator.open(new PerWindowStateDataViewStore(this.ctx.getKeyedStateBackend(), (TypeSerializer<?>)namespaceSerializer, this.ctx.getRuntimeContext()));
        this.windowBuffer = this.windowBufferFactory.create(this.ctx.getOperatorOwner(), this.ctx.getMemoryManager(), this.ctx.getMemorySize(), this.ctx.getRuntimeContext(), this.windowTimerService, this.ctx.getKeyedStateBackend(), this.windowState, this.isEventTime, this.shiftTimeZone);
        this.reuseOutput = new JoinedRowData();
        this.currentProgress = Long.MIN_VALUE;
        this.nextTriggerProgress = Long.MIN_VALUE;
    }

    @Override
    public void initializeWatermark(long watermark) {
        if (this.isEventTime) {
            this.currentProgress = watermark;
        }
    }

    @Override
    public boolean processElement(RowData key, RowData element) throws Exception {
        long sliceEnd = this.sliceAssigner.assignSliceEnd(element, this.clockService);
        if (!this.isEventTime) {
            this.windowTimerService.registerProcessingTimeWindowTimer(sliceEnd);
        }
        if (this.isEventTime && TimeWindowUtil.isWindowFired(sliceEnd, this.currentProgress, this.shiftTimeZone)) {
            long lastWindowEnd = this.sliceAssigner.getLastWindowEnd(sliceEnd);
            if (TimeWindowUtil.isWindowFired(lastWindowEnd, this.currentProgress, this.shiftTimeZone)) {
                return true;
            }
            this.windowBuffer.addElement(key, this.sliceStateMergeTarget(sliceEnd), element);
            long unfiredFirstWindow = sliceEnd;
            while (TimeWindowUtil.isWindowFired(unfiredFirstWindow, this.currentProgress, this.shiftTimeZone)) {
                unfiredFirstWindow += this.windowInterval;
            }
            this.windowTimerService.registerEventTimeWindowTimer(unfiredFirstWindow);
            return false;
        }
        this.windowBuffer.addElement(key, sliceEnd, element);
        return false;
    }

    protected abstract long sliceStateMergeTarget(long var1) throws Exception;

    @Override
    public void advanceProgress(long progress) throws Exception {
        if (progress > this.currentProgress) {
            this.currentProgress = progress;
            if (this.currentProgress >= this.nextTriggerProgress) {
                this.windowBuffer.advanceProgress(this.currentProgress);
                this.nextTriggerProgress = TimeWindowUtil.getNextTriggerWatermark(this.currentProgress, this.windowInterval, this.shiftTimeZone, this.useDayLightSaving);
            }
        }
    }

    @Override
    public void prepareCheckpoint() throws Exception {
        this.windowBuffer.flush();
    }

    @Override
    public void clearWindow(Long windowEnd) throws Exception {
        Iterable<Long> expires = this.sliceAssigner.expiredSlices(windowEnd);
        for (Long slice : expires) {
            this.windowState.clear(slice);
            this.aggregator.cleanup(slice);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.aggregator != null) {
            this.aggregator.close();
        }
        if (this.windowBuffer != null) {
            this.windowBuffer.close();
        }
    }

    @Override
    public TypeSerializer<Long> createWindowSerializer() {
        return LongSerializer.INSTANCE;
    }

    protected void collect(RowData aggResult) {
        this.reuseOutput.replace((RowData)this.ctx.getKeyedStateBackend().getCurrentKey(), aggResult);
        this.ctx.output((RowData)this.reuseOutput);
    }
}

