/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.runtime.typeutils.ExternalSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeQueryable;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.util.Preconditions;

@Internal
public final class ExternalTypeInfo<T>
extends TypeInformation<T>
implements DataTypeQueryable {
    private static final String FORMAT = "%s(%s, %s)";
    private final DataType dataType;
    private final TypeSerializer<T> typeSerializer;

    private ExternalTypeInfo(DataType dataType, TypeSerializer<T> typeSerializer) {
        this.dataType = (DataType)Preconditions.checkNotNull((Object)dataType);
        this.typeSerializer = (TypeSerializer)Preconditions.checkNotNull(typeSerializer);
    }

    public static <T> ExternalTypeInfo<T> of(DataType dataType) {
        TypeSerializer<T> serializer = ExternalTypeInfo.createExternalTypeSerializer(dataType, false);
        return new ExternalTypeInfo<T>(dataType, serializer);
    }

    public static <T> ExternalTypeInfo<T> of(DataType dataType, boolean isInternalInput) {
        TypeSerializer<T> serializer = ExternalTypeInfo.createExternalTypeSerializer(dataType, isInternalInput);
        return new ExternalTypeInfo<T>(dataType, serializer);
    }

    private static <T> TypeSerializer<T> createExternalTypeSerializer(DataType dataType, boolean isInternalInput) {
        LogicalType logicalType = dataType.getLogicalType();
        if (logicalType instanceof RawType && !isInternalInput) {
            RawType rawType = (RawType)logicalType;
            if (dataType.getConversionClass() == rawType.getOriginatingClass()) {
                return rawType.getTypeSerializer();
            }
        }
        return ExternalSerializer.of(dataType, isInternalInput);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.dataType.getConversionClass();
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<T> createSerializer(SerializerConfig config) {
        return this.typeSerializer;
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return this.createSerializer(config.getSerializerConfig());
    }

    public String toString() {
        return String.format(FORMAT, this.dataType.getLogicalType().asSummaryString(), this.dataType.getConversionClass().getName(), this.typeSerializer.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ExternalTypeInfo that = (ExternalTypeInfo)((Object)o);
        return this.typeSerializer.equals(that.typeSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.typeSerializer);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof ExternalTypeInfo;
    }
}

