/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.dataview;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.runtime.dataview.DataViewSpec;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;

@Internal
public class MapViewSpec
extends DataViewSpec {
    private final boolean containsNullKey;
    @Nullable
    private final TypeSerializer<?> keySerializer;
    @Nullable
    private final TypeSerializer<?> valueSerializer;

    public MapViewSpec(String stateId, int fieldIndex, DataType dataType, boolean containsNullKey) {
        this(stateId, fieldIndex, dataType, containsNullKey, null, null);
    }

    @Deprecated
    public MapViewSpec(String stateId, int fieldIndex, DataType dataType, boolean containsNullKey, TypeSerializer<?> keySerializer, TypeSerializer<?> valueSerializer) {
        super(stateId, fieldIndex, dataType);
        this.containsNullKey = containsNullKey;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public DataType getKeyDataType() {
        KeyValueDataType mapDataType = (KeyValueDataType)this.getDataType();
        return mapDataType.getKeyDataType();
    }

    public DataType getValueDataType() {
        KeyValueDataType mapDataType = (KeyValueDataType)this.getDataType();
        return mapDataType.getValueDataType();
    }

    public Optional<TypeSerializer<?>> getKeySerializer() {
        return Optional.ofNullable(this.keySerializer);
    }

    public Optional<TypeSerializer<?>> getValueSerializer() {
        return Optional.ofNullable(this.valueSerializer);
    }

    public boolean containsNullKey() {
        return this.containsNullKey;
    }
}

