/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.event;

import java.util.Map;
import java.util.UUID;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.tools.ToolResponse;

public class ToolResponseEvent
extends Event {
    private final UUID requestId;
    private final Map<String, ToolResponse> responses;
    private final Map<String, String> externalIds;
    private final Map<String, Boolean> success;
    private final Map<String, String> error;
    private final long timestamp;

    public ToolResponseEvent(UUID requestId, Map<String, ToolResponse> responses, Map<String, Boolean> success, Map<String, String> error, Map<String, String> externalIds) {
        this.requestId = requestId;
        this.responses = responses;
        this.success = success;
        this.error = error;
        this.externalIds = externalIds;
        this.timestamp = System.currentTimeMillis();
    }

    public ToolResponseEvent(UUID requestId, Map<String, ToolResponse> responses, Map<String, Boolean> success, Map<String, String> error) {
        this(requestId, responses, success, error, Map.of());
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public Map<String, ToolResponse> getResponses() {
        return this.responses;
    }

    public Map<String, String> getExternalIds() {
        return this.externalIds;
    }

    public Map<String, Boolean> getSuccess() {
        return this.success;
    }

    public Map<String, String> getError() {
        return this.error;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "ToolResponseEvent{requestId=" + String.valueOf(this.requestId) + ", response=" + String.valueOf(this.responses) + ", success=true, timestamp=" + this.timestamp + "}";
    }
}

