CREATE TABLE dynamo_db_table (
    `partition_key` STRING,
    `sort_key` STRING,
    `some_char` CHAR,
    `some_varchar` VARCHAR,
    `some_string` STRING,
    `some_boolean` BOOLEAN,
    `some_decimal` DECIMAL,
    `some_tinyint` TINYINT,
    `some_smallint` SMALLINT,
    `some_int` INT,
    `some_bigint` BIGINT,
    `some_float` FLOAT,
    `some_date` DATE,
    `some_time` TIME,
    `some_timestamp` TIMESTAMP(3),
    `some_timestamp_ltz` TIMESTAMP_LTZ(5),
    `some_char_array` ARRAY<CHAR>,
    `some_varchar_array` ARRAY<VARCHAR>,
    `some_string_array` ARRAY<STRING>,
    `some_boolean_array` ARRAY<BOOLEAN>,
    `some_decimal_array` ARRAY<DECIMAL>,
    `some_tinyint_array` ARRAY<TINYINT>,
    `some_smallint_array` ARRAY<SMALLINT>,
    `some_int_array` ARRAY<INT>,
    `some_bigint_array` ARRAY<BIGINT>,
    `some_float_array` ARRAY<FLOAT>,
    `some_date_array` ARRAY<DATE>,
    `some_time_array` ARRAY<TIME>,
    `some_timestamp_array` ARRAY<TIMESTAMP(3)>,
    `some_timestamp_ltz_array` ARRAY<TIMESTAMP_LTZ(5)>,
    `some_string_map` MAP<STRING,STRING>,
    `some_boolean_map` MAP<STRING,BOOLEAN>
) PARTITIONED BY ( partition_key )
    WITH (
        'connector' = 'dynamodb',
        'table-name' = '${tableName}',
        'aws.region' = '${region}',
        'aws.endpoint' = '${endpoint}',
        'aws.credentials.provider' = 'BASIC',
        'aws.credentials.basic.accesskeyid' = '${accessKey}',
        'aws.credentials.basic.secretkey' = '${secretKey}',
        'aws.trust.all.certificates' = 'true',
        'aws.http.protocol.version' = 'HTTP1_1'
        );