/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.Objects;
import java.util.OptionalLong;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.functions.DelayMessageHandler;
import org.apache.flink.statefun.flink.core.functions.DelayedMessagesBuffer;
import org.apache.flink.statefun.flink.core.functions.TimerServiceFactory;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.util.Preconditions;

final class DelaySink
implements Triggerable<String, VoidNamespace> {
    private final InternalTimerService<VoidNamespace> delayedMessagesTimerService;
    private final DelayedMessagesBuffer delayedMessagesBuffer;
    private final DelayMessageHandler delayMessageHandler;

    @Inject
    DelaySink(@Label(value="delayed-messages-buffer") DelayedMessagesBuffer delayedMessagesBuffer, @Label(value="delayed-messages-timer-service-factory") TimerServiceFactory delayedMessagesTimerServiceFactory, DelayMessageHandler delayMessageHandler) {
        this.delayedMessagesBuffer = Objects.requireNonNull(delayedMessagesBuffer);
        this.delayedMessagesTimerService = delayedMessagesTimerServiceFactory.createTimerService(this);
        this.delayMessageHandler = Objects.requireNonNull(delayMessageHandler);
    }

    void accept(Message message, long delayMillis) {
        Objects.requireNonNull(message);
        Preconditions.checkArgument((delayMillis >= 0L ? 1 : 0) != 0);
        long triggerTime = this.delayedMessagesTimerService.currentProcessingTime() + delayMillis;
        this.delayedMessagesTimerService.registerProcessingTimeTimer((Object)VoidNamespace.INSTANCE, triggerTime);
        this.delayedMessagesBuffer.add(message, triggerTime);
    }

    public void onProcessingTime(InternalTimer<String, VoidNamespace> timer) {
        this.delayMessageHandler.onStart();
        this.delayedMessagesBuffer.forEachMessageAt(timer.getTimestamp(), this.delayMessageHandler);
        this.delayMessageHandler.onComplete();
    }

    public void onEventTime(InternalTimer<String, VoidNamespace> timer) {
        throw new UnsupportedOperationException("Delayed messages with event time semantics is not supported.");
    }

    void removeMessageByCancellationToken(String cancellationToken) {
        Objects.requireNonNull(cancellationToken);
        OptionalLong timerToClear = this.delayedMessagesBuffer.removeMessageByCancellationToken(cancellationToken);
        if (timerToClear.isPresent()) {
            long timestamp = timerToClear.getAsLong();
            this.delayedMessagesTimerService.deleteProcessingTimeTimer((Object)VoidNamespace.INSTANCE, timestamp);
        }
    }
}

