/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okio.Timeout;
import org.apache.flink.statefun.flink.core.backpressure.BoundedExponentialBackoff;
import org.apache.flink.statefun.flink.core.metrics.RemoteInvocationMetrics;
import org.apache.flink.statefun.flink.core.reqreply.ToFunctionRequestSummary;
import org.apache.flink.util.function.RunnableWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RetryingCallback
implements Callback {
    private static final Duration INITIAL_BACKOFF_DURATION = Duration.ofMillis(10L);
    private static final Set<Integer> RETRYABLE_HTTP_CODES = new HashSet<Integer>(Arrays.asList(409, 420, 408, 429, 499, 500));
    private static final Logger LOG = LoggerFactory.getLogger(RetryingCallback.class);
    private final CompletableFuture<Response> resultFuture = new CompletableFuture();
    private final BoundedExponentialBackoff backoff;
    private final ToFunctionRequestSummary requestSummary;
    private final RemoteInvocationMetrics metrics;
    private final BooleanSupplier isShutdown;
    private long requestStarted;

    RetryingCallback(ToFunctionRequestSummary requestSummary, RemoteInvocationMetrics metrics, Timeout timeout, BooleanSupplier isShutdown) {
        this.backoff = new BoundedExponentialBackoff(INITIAL_BACKOFF_DURATION, RetryingCallback.duration(timeout));
        this.requestSummary = requestSummary;
        this.metrics = metrics;
        this.isShutdown = Objects.requireNonNull(isShutdown);
    }

    CompletableFuture<Response> future() {
        return this.resultFuture;
    }

    void attachToCall(Call call) {
        this.requestStarted = System.nanoTime();
        call.enqueue((Callback)this);
    }

    public void onFailure(Call call, IOException cause) {
        this.tryWithFuture(() -> this.onFailureUnsafe(call, cause));
    }

    public void onResponse(Call call, Response response) {
        this.tryWithFuture(() -> this.onResponseUnsafe(call, response));
    }

    private void onFailureUnsafe(Call call, IOException cause) {
        if (this.isShutdown.getAsBoolean()) {
            throw new IllegalStateException("An exception caught during shutdown.", cause);
        }
        LOG.warn("Retriable exception caught while trying to deliver a message: " + this.requestSummary, (Throwable)cause);
        this.metrics.remoteInvocationFailures();
        if (!this.retryAfterApplyingBackoff(call)) {
            throw new IllegalStateException("Maximal request time has elapsed. Last cause is attached", cause);
        }
    }

    private void onResponseUnsafe(Call call, Response response) {
        if (response.isSuccessful()) {
            this.resultFuture.complete(response);
            return;
        }
        if (!RETRYABLE_HTTP_CODES.contains(response.code()) && response.code() < 500) {
            throw new IllegalStateException("Non successful HTTP response code " + response.code());
        }
        if (!this.retryAfterApplyingBackoff(call)) {
            throw new IllegalStateException("Maximal request time has elapsed. Last known error is: invalid HTTP response code " + response.code());
        }
    }

    private boolean retryAfterApplyingBackoff(Call call) {
        if (this.backoff.applyNow()) {
            Call newCall = call.clone();
            this.attachToCall(newCall);
            return true;
        }
        return false;
    }

    private void tryWithFuture(RunnableWithException runnable) {
        try {
            this.endTimingRequest();
            runnable.run();
        }
        catch (Throwable t) {
            this.resultFuture.completeExceptionally(t);
        }
    }

    private static Duration duration(Timeout timeout) {
        return Duration.ofNanos(timeout.timeoutNanos());
    }

    private void endTimingRequest() {
        long nanosecondsElapsed = System.nanoTime() - this.requestStarted;
        long millisecondsElapsed = TimeUnit.NANOSECONDS.toMillis(nanosecondsElapsed);
        this.metrics.remoteInvocationLatency(millisecondsElapsed);
    }
}

