/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.logger;

import java.util.ArrayDeque;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentSource;

@NotThreadSafe
final class MemorySegmentPool
implements MemorySegmentSource {
    static final int PAGE_SIZE = 65536;
    private final ArrayDeque<MemorySegment> pool = new ArrayDeque();
    private final long inMemoryBufferSize;
    private long totalAllocatedMemory;

    MemorySegmentPool(long inMemoryBufferSize) {
        this.inMemoryBufferSize = inMemoryBufferSize;
    }

    @Nullable
    public MemorySegment nextSegment() {
        MemorySegment segment = this.pool.pollFirst();
        if (segment != null) {
            return segment;
        }
        if (!this.hasRemainingCapacity()) {
            return null;
        }
        segment = MemorySegmentFactory.allocateUnpooledSegment((int)65536);
        this.totalAllocatedMemory += 65536L;
        return segment;
    }

    void release(MemorySegment segment) {
        if (this.totalAllocatedMemory > this.inMemoryBufferSize) {
            segment.free();
            this.totalAllocatedMemory -= 65536L;
            return;
        }
        this.pool.add(segment);
    }

    int getSegmentSize() {
        return 65536;
    }

    void ensureAtLeastOneSegmentPresent() {
        if (!this.pool.isEmpty()) {
            return;
        }
        if (this.hasRemainingCapacity()) {
            return;
        }
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)65536);
        this.totalAllocatedMemory += 65536L;
        this.pool.add(segment);
    }

    private boolean hasRemainingCapacity() {
        return this.totalAllocatedMemory + 65536L <= this.inMemoryBufferSize;
    }
}

