/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelDuplexHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslCloseCompletionEvent;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.ScheduledFuture;
import org.apache.flink.statefun.flink.core.nettyclient.ChannelAttributes;

final class HttpConnectionPoolHandler
extends ChannelDuplexHandler {
    private final long ttlMs;
    @Nullable
    private ScheduledFuture<?> timer;

    HttpConnectionPoolHandler(long connectionTtlMs) {
        this.ttlMs = connectionTtlMs;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelRegistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelActive(ctx);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.handlerRemoved(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    private void initialize(ChannelHandlerContext ctx) {
        if (this.ttlMs <= 0L) {
            return;
        }
        if (this.timer != null) {
            return;
        }
        long channelTimeToLive = this.ttlMs + (long)HttpConnectionPoolHandler.positiveRandomJitterMillis();
        this.timer = ctx.channel().eventLoop().schedule(() -> this.tryExpire(ctx, false), channelTimeToLive, TimeUnit.MILLISECONDS);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (!(evt instanceof SslCloseCompletionEvent)) {
            return;
        }
        this.tryExpire(ctx, true);
    }

    private void destroy() {
        if (this.timer != null) {
            this.timer.cancel(false);
            this.timer = null;
        }
    }

    private void tryExpire(ChannelHandlerContext ctx, boolean shouldCancelTimer) {
        if (shouldCancelTimer && this.timer != null) {
            this.timer.cancel(false);
        }
        this.timer = null;
        Channel channel = ctx.channel();
        channel.attr(ChannelAttributes.EXPIRED).set((Object)Boolean.TRUE);
        if (channel.isActive() && channel.attr(ChannelAttributes.ACQUIRED).get() == Boolean.FALSE) {
            channel.close();
        }
    }

    private static int positiveRandomJitterMillis() {
        return ThreadLocalRandom.current().nextInt(1000, 3000);
    }
}

