/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.reqreply;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.statefun.flink.core.metrics.RemoteInvocationMetrics;
import org.apache.flink.statefun.flink.core.reqreply.RequestReplyClient;
import org.apache.flink.statefun.flink.core.reqreply.ToFunctionRequestSummary;
import org.apache.flink.statefun.sdk.reqreply.generated.FromFunction;
import org.apache.flink.statefun.sdk.reqreply.generated.ToFunction;

public final class ClassLoaderSafeRequestReplyClient
implements RequestReplyClient {
    private final ClassLoader delegateClassLoader;
    private final RequestReplyClient delegate;

    public ClassLoaderSafeRequestReplyClient(RequestReplyClient delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.delegateClassLoader = delegate.getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<FromFunction> call(ToFunctionRequestSummary requestSummary, RemoteInvocationMetrics metrics, ToFunction toFunction) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.delegateClassLoader);
            CompletableFuture<FromFunction> completableFuture = this.delegate.call(requestSummary, metrics, toFunction);
            return completableFuture;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

