/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.state;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.statefun.sdk.state.Accessor;

final class FlinkValueAccessor<T>
implements Accessor<T> {
    private final ValueState<T> handle;

    FlinkValueAccessor(ValueState<T> handle) {
        this.handle = Objects.requireNonNull(handle);
    }

    public void set(T value) {
        try {
            if (value == null) {
                this.handle.clear();
            } else {
                this.handle.update(value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public T get() {
        try {
            return (T)this.handle.value();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.handle.clear();
    }
}

