/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.types.remote;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.core.types.remote.RemoteValueSerializer;
import org.apache.flink.statefun.flink.core.types.remote.RemoteValueTypeMismatchException;
import org.apache.flink.statefun.sdk.TypeName;

public class RemoteValueSerializerSnapshot
implements TypeSerializerSnapshot<byte[]> {
    private static final Integer VERSION = 1;
    private TypeName type;

    public RemoteValueSerializerSnapshot() {
    }

    RemoteValueSerializerSnapshot(TypeName type) {
        this.type = type;
    }

    public TypeName type() {
        return this.type;
    }

    public int getCurrentVersion() {
        return VERSION;
    }

    public void writeSnapshot(DataOutputView dataOutputView) throws IOException {
        dataOutputView.writeUTF(this.type.namespace());
        dataOutputView.writeUTF(this.type.name());
    }

    public void readSnapshot(int i, DataInputView dataInputView, ClassLoader classLoader) throws IOException {
        String namespace = dataInputView.readUTF();
        String name = dataInputView.readUTF();
        this.type = new TypeName(namespace, name);
    }

    public TypeSerializer<byte[]> restoreSerializer() {
        return new RemoteValueSerializer(this.type);
    }

    public TypeSerializerSchemaCompatibility<byte[]> resolveSchemaCompatibility(TypeSerializer<byte[]> otherSerializer) {
        if (!(otherSerializer instanceof RemoteValueSerializer)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        RemoteValueSerializer otherRemoteTypeSerializer = (RemoteValueSerializer)otherSerializer;
        if (!this.type.equals((Object)otherRemoteTypeSerializer.getType())) {
            throw new RemoteValueTypeMismatchException(this.type, otherRemoteTypeSerializer.getType());
        }
        return TypeSerializerSchemaCompatibility.compatibleAsIs();
    }
}

