/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.broadcast;

import java.io.IOException;
import java.util.List;
import org.apache.flink.iteration.broadcast.BroadcastOutput;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class CountingBroadcastOutput<OUT>
implements BroadcastOutput<OUT> {
    private final Counter numRecordsOut;
    private final List<BroadcastOutput<OUT>> internalOutputs;

    public CountingBroadcastOutput(Counter numRecordsOut, List<BroadcastOutput<OUT>> internalOutputs) {
        this.numRecordsOut = numRecordsOut;
        this.internalOutputs = internalOutputs;
    }

    @Override
    public void broadcastEmit(StreamRecord<OUT> record) throws IOException {
        this.numRecordsOut.inc();
        for (BroadcastOutput<OUT> internalOutput : this.internalOutputs) {
            internalOutput.broadcastEmit(record);
        }
    }
}

