/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.compile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.DefaultExecutorServiceLoader;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.iteration.compile.DraftTransformationTranslator;
import org.apache.flink.iteration.compile.translator.BroadcastStateTransformationTranslator;
import org.apache.flink.iteration.compile.translator.KeyedBroadcastStateTransformationTranslator;
import org.apache.flink.iteration.compile.translator.MultipleInputTransformationTranslator;
import org.apache.flink.iteration.compile.translator.OneInputTransformationTranslator;
import org.apache.flink.iteration.compile.translator.PartitionTransformationTranslator;
import org.apache.flink.iteration.compile.translator.ReduceTransformationTranslator;
import org.apache.flink.iteration.compile.translator.SideOutputTransformationTranslator;
import org.apache.flink.iteration.compile.translator.TwoInputTransformationTranslator;
import org.apache.flink.iteration.compile.translator.UnionTransformationTranslator;
import org.apache.flink.iteration.operator.OperatorWrapper;
import org.apache.flink.iteration.utils.ReflectionUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.transformations.BroadcastStateTransformation;
import org.apache.flink.streaming.api.transformations.KeyedBroadcastStateTransformation;
import org.apache.flink.streaming.api.transformations.KeyedMultipleInputTransformation;
import org.apache.flink.streaming.api.transformations.MultipleInputTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.ReduceTransformation;
import org.apache.flink.streaming.api.transformations.SideOutputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.api.transformations.UnionTransformation;
import org.apache.flink.util.Preconditions;

public class DraftExecutionEnvironment
extends StreamExecutionEnvironment {
    private static final Map<Class<? extends Transformation>, DraftTransformationTranslator> translators = new HashMap<Class<? extends Transformation>, DraftTransformationTranslator>();
    private final StreamExecutionEnvironment actualEnv;
    private final Set<Integer> explicitlyAddedTransformations;
    private final Map<Integer, OperatorWrapper<?, ?>> draftWrappers;
    private final Map<Integer, Transformation<?>> draftToActualTransformations;
    private OperatorWrapper<?, ?> currentWrapper;

    public DraftExecutionEnvironment(StreamExecutionEnvironment actualEnv, OperatorWrapper<?, ?> initialWrapper) {
        super((PipelineExecutorServiceLoader)new DefaultExecutorServiceLoader(), (Configuration)ReflectionUtils.getFieldValue(actualEnv, StreamExecutionEnvironment.class, "configuration"), (ClassLoader)ReflectionUtils.getFieldValue(actualEnv, StreamExecutionEnvironment.class, "userClassloader"));
        this.actualEnv = actualEnv;
        this.explicitlyAddedTransformations = new HashSet<Integer>();
        this.draftWrappers = new HashMap();
        this.draftToActualTransformations = new HashMap();
        this.setParallelism(actualEnv.getParallelism());
        if (actualEnv.getMaxParallelism() > 0) {
            this.setMaxParallelism(actualEnv.getMaxParallelism());
        }
        this.setBufferTimeout(actualEnv.getBufferTimeout());
        this.currentWrapper = initialWrapper;
    }

    public OperatorWrapper<?, ?> setCurrentWrapper(OperatorWrapper<?, ?> newWrapper) {
        OperatorWrapper<?, ?> oldWrapper = this.currentWrapper;
        this.currentWrapper = newWrapper;
        return oldWrapper;
    }

    public void addOperator(Transformation<?> transformation) {
        this.recordWrapper(transformation);
        super.addOperator(transformation);
        this.explicitlyAddedTransformations.add(transformation.getId());
    }

    private void recordWrapper(Transformation<?> transformation) {
        if (this.draftWrappers.containsKey(transformation.getId()) || this.draftToActualTransformations.containsKey(transformation.getId())) {
            return;
        }
        this.draftWrappers.put(transformation.getId(), this.currentWrapper);
        for (Transformation input : transformation.getInputs()) {
            this.recordWrapper(input);
        }
    }

    public void addOperatorIfNotExists(Transformation<?> transformation) {
        if (!this.explicitlyAddedTransformations.contains(transformation.getId())) {
            this.addOperator(transformation);
        }
    }

    public <T> DataStream<T> addDraftSource(DataStream<?> actualStream, TypeInformation<T> draftOutputType) {
        SingleOutputStreamOperator draftSource = this.addSource((SourceFunction)new EmptySource()).setParallelism(actualStream.getParallelism()).returns(draftOutputType);
        this.addOperator(draftSource.getTransformation());
        this.draftToActualTransformations.put(draftSource.getId(), actualStream.getTransformation());
        return draftSource;
    }

    public void copyToActualEnvironment() {
        for (Transformation draftTransformation : this.transformations) {
            this.transform(draftTransformation);
        }
    }

    public <T> DataStream<T> getActualStream(int draftTransformationId) {
        return new DataStream(this.actualEnv, this.getActualTransformation(draftTransformationId));
    }

    private <TF extends Transformation<?>> void transform(TF draftTransformation) {
        if (this.draftToActualTransformations.containsKey(draftTransformation.getId())) {
            return;
        }
        for (Transformation draftInput : draftTransformation.getInputs()) {
            this.transform(draftInput);
        }
        OperatorWrapper<?, ?> operatorWrapper = Objects.requireNonNull(this.draftWrappers.get(draftTransformation.getId()));
        DraftTransformationTranslator transformationTranslator = translators.get(draftTransformation.getClass());
        Preconditions.checkState((transformationTranslator != null ? 1 : 0) != 0, (Object)("Unsupported transformation: " + draftTransformation));
        Transformation<?> actualTransformation = transformationTranslator.translate(draftTransformation, operatorWrapper, new TranslatorContext());
        this.actualEnv.addOperator(actualTransformation);
        this.draftToActualTransformations.put(draftTransformation.getId(), actualTransformation);
    }

    private <T> Transformation<T> getActualTransformation(int draftTransformationId) {
        return Objects.requireNonNull(this.draftToActualTransformations.get(draftTransformationId));
    }

    public JobExecutionResult execute(StreamGraph streamGraph) throws Exception {
        throw new UnsupportedOperationException("Unable to execute with a draft execution environment.");
    }

    static {
        translators.put(BroadcastStateTransformation.class, new BroadcastStateTransformationTranslator());
        translators.put(KeyedBroadcastStateTransformation.class, new KeyedBroadcastStateTransformationTranslator());
        translators.put(KeyedMultipleInputTransformation.class, new KeyedBroadcastStateTransformationTranslator());
        translators.put(MultipleInputTransformation.class, new MultipleInputTransformationTranslator());
        translators.put(OneInputTransformation.class, new OneInputTransformationTranslator());
        translators.put(PartitionTransformation.class, new PartitionTransformationTranslator());
        translators.put(ReduceTransformation.class, new ReduceTransformationTranslator());
        translators.put(SideOutputTransformation.class, new SideOutputTransformationTranslator());
        translators.put(TwoInputTransformation.class, new TwoInputTransformationTranslator());
        translators.put(UnionTransformation.class, new UnionTransformationTranslator());
    }

    public static class EmptySource<T>
    extends RichParallelSourceFunction<T> {
        public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        }

        public void cancel() {
        }
    }

    private class TranslatorContext
    implements DraftTransformationTranslator.Context {
        private TranslatorContext() {
        }

        @Override
        public Transformation<?> getActualTransformation(int draftId) {
            return DraftExecutionEnvironment.this.getActualTransformation(draftId);
        }

        @Override
        public ExecutionConfig getExecutionConfig() {
            return DraftExecutionEnvironment.this.getConfig();
        }
    }
}

